/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fusion.aci.api.event.InstallationCompletedEvent;
import com.atlassian.fusion.aci.api.event.UninstallationCompletedEvent;
import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.CredentialType;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AciLifeCycleListener {
    private static final Logger log = LoggerFactory.getLogger(AciLifeCycleListener.class);
    private final AnalyticsService analyticsService;
    private final EventPublisher eventPublisher;
    private final OrganizationService organizationService;

    @Inject
    public AciLifeCycleListener(@ComponentImport @Nonnull EventPublisher eventPublisher, @Nonnull AnalyticsService analyticsService, @Nonnull OrganizationService organizationService) {
        this.analyticsService = (AnalyticsService)Preconditions.checkNotNull((Object)analyticsService);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
    }

    @PostConstruct
    private void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    private void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void createOrUpdateDvcsOrganisation(InstallationCompletedEvent e) {
        if (e == null || !"jira-bitbucket-connector-plugin".equals(e.getApplicationId())) {
            return;
        }
        log.debug("Received installation completed event for {}", (Object)e.getPrincipalId());
        Installation installation = e.getInstallation();
        Organization org = this.organizationService.getByHostAndName(installation.getBaseUrl(), installation.getPrincipalUsername());
        if (org != null) {
            this.organizationService.migrateExistingOrgToPrincipalCredentialOrg(org, installation.getPrincipalUuid());
        } else {
            this.organizationService.createNewOrgBasedOnAciInstallation(installation);
        }
    }

    @EventListener
    public void removeDvcsOrganisation(UninstallationCompletedEvent e) {
        if (e == null || !"jira-bitbucket-connector-plugin".equals(e.getApplicationId())) {
            return;
        }
        log.debug("Received uninstallation completed event for {}", (Object)e.getPrincipalId());
        Installation installation = e.getInstallation();
        Optional<Organization> organizationOptional = this.getOrgUsingInstallation(installation).filter(org -> this.credentialIsPrincipalBased((Organization)org, installation));
        if (organizationOptional.isPresent()) {
            Organization organization = organizationOptional.get();
            this.organizationService.remove(organization.getId());
        }
    }

    private boolean credentialIsPrincipalBased(Organization organization, Installation installation) {
        boolean isPrincipalBased;
        boolean bl = isPrincipalBased = organization.getCredential().getType() == CredentialType.PRINCIPAL_ID;
        if (!isPrincipalBased) {
            log.warn("Received a request from ACI to remove organisation with host '{}' and username '{}' but that organisation is not managed by ACI", (Object)installation.getBaseUrl(), (Object)installation.getPrincipalUsername());
        }
        return isPrincipalBased;
    }

    private Optional<Organization> getOrgUsingInstallation(Installation installation) {
        Organization org = this.organizationService.getByHostAndName(installation.getBaseUrl(), installation.getPrincipalUsername());
        if (org == null) {
            log.warn("Received a request from ACI to remove organisation with host '{}' and username '{}' but no such organisation exists", (Object)installation.getBaseUrl(), (Object)installation.getPrincipalUsername());
        }
        return Optional.ofNullable(org);
    }
}

