/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.featurediscovery;

import com.atlassian.jira.plugins.dvcs.featurediscovery.FeatureDiscoveryService;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;

@Named
@ParametersAreNonnullByDefault
public class FeatureDiscoveryServiceImpl
implements FeatureDiscoveryService {
    public static final String FEATURE_DISCOVERY_USER_SETTINGS_KEY = "com.atlassian.jira.plugins.dvcs.featurediscovery";
    private static final Logger log = ExceptionLogger.getLogger(FeatureDiscoveryServiceImpl.class);
    private final UserManager userManager;
    private final UserSettingsService userSettingsService;

    @Inject
    public FeatureDiscoveryServiceImpl(@ComponentImport(value="salUserManager") UserManager userManager, @ComponentImport UserSettingsService userSettingsService) {
        this.userManager = Objects.requireNonNull(userManager);
        this.userSettingsService = Objects.requireNonNull(userSettingsService);
    }

    @Override
    public boolean hasUserSeenFeatureDiscovery() {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            log.debug("No logged in user found - cannot retrieve feature discovery flag.");
            return true;
        }
        try {
            return (Boolean)this.userSettingsService.getUserSettings(user).getBoolean(FEATURE_DISCOVERY_USER_SETTINGS_KEY).getOrElse((Object)Boolean.FALSE);
        }
        catch (Exception e) {
            log.debug("Exception occurred while retrieving feature discovery flag from user settings.", (Throwable)e);
            return true;
        }
    }

    @Override
    public void markUserAsHavingSeenFeatureDiscovery(boolean hasSeenFeatureDiscovery) {
        UserKey user = this.userManager.getRemoteUserKey();
        if (user == null) {
            log.debug("No logged in user found - cannot update feature discovery flag.");
            return;
        }
        try {
            this.userSettingsService.updateUserSettings(user, b -> b.put(FEATURE_DISCOVERY_USER_SETTINGS_KEY, hasSeenFeatureDiscovery).build());
        }
        catch (Exception e) {
            log.debug("Exception occurred while updating feature discovery flag in user settings.", (Throwable)e);
        }
    }
}

