/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.ThreadEventsCaptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ThreadEvents {
    private static final Logger logger = LoggerFactory.getLogger(ThreadEvents.class);
    private final ThreadLocal<ThreadEventsCaptor> threadEventCaptor = new ThreadLocal();

    @Nonnull
    public ThreadEventsCaptor startCapturing() {
        if (this.threadEventCaptor.get() != null) {
            throw new IllegalStateException("There is already an active ThreadEventsCapture");
        }
        return new ThreadEventsCaptorImpl();
    }

    public void broadcast(Object event) {
        ThreadEventsCaptor eventCaptor = this.threadEventCaptor.get();
        if (eventCaptor != null) {
            eventCaptor.accept(event);
        } else {
            logger.debug("There is no active ThreadEventsCaptor. Dropping event: {}", event);
        }
    }

    private final class ThreadEventsCaptorImpl
    implements ThreadEventsCaptor {
        private final List<Object> capturedEvents = Lists.newArrayList();

        ThreadEventsCaptorImpl() {
            ThreadEvents.this.threadEventCaptor.set(this);
        }

        @Override
        @Nonnull
        public ThreadEventsCaptor stopCapturing() {
            ThreadEvents.this.threadEventCaptor.remove();
            return this;
        }

        @Override
        public void processEach(@Nonnull Consumer<Object> closure) {
            this.processEach(Object.class, closure);
        }

        @Override
        public <T> void processEach(@Nonnull Class<T> eventClass, @Nonnull Consumer<? super T> consumer) {
            Preconditions.checkNotNull(eventClass);
            Preconditions.checkNotNull(consumer);
            ImmutableList all = ImmutableList.copyOf(this.capturedEvents);
            all.stream().filter(eventClass::isInstance).map(eventClass::cast).forEach(event -> {
                logger.debug("Processing event with {}: {}", (Object)consumer, event);
                consumer.accept(event);
                this.capturedEvents.remove(event);
            });
            logger.debug("Processed {} events of type {} with {}", new Object[]{all.size() - this.capturedEvents.size(), eventClass, consumer});
        }

        @Override
        public void accept(@Nonnull Object event) {
            logger.debug("Capturing event: {}", event);
            this.capturedEvents.add(event);
        }
    }
}

