/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.CapturingRepositorySync;
import com.atlassian.jira.plugins.dvcs.event.CarefulEventService;
import com.atlassian.jira.plugins.dvcs.event.EventsFeature;
import com.atlassian.jira.plugins.dvcs.event.RepositorySync;
import com.atlassian.jira.plugins.dvcs.event.ThreadEvents;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositorySyncFactory {
    private static final RepositorySync NO_OP_REPO_SYNC = () -> {};
    private final CarefulEventService eventService;
    private final EventsFeature eventsFeature;
    private final ThreadEvents threadEvents;

    @Autowired
    public RepositorySyncFactory(@Nonnull ThreadEvents threadEvents, @Nonnull CarefulEventService eventService, @Nonnull EventsFeature eventsFeature) {
        this.eventService = Objects.requireNonNull(eventService);
        this.eventsFeature = Objects.requireNonNull(eventsFeature);
        this.threadEvents = Objects.requireNonNull(threadEvents);
    }

    @Nonnull
    public RepositorySync getInstance(@Nullable Repository repository, @Nonnull Collection<SynchronizationFlag> syncFlags) {
        Objects.requireNonNull(syncFlags);
        if (this.eventsFeature.isEnabled() && repository != null && syncFlags.contains(SynchronizationFlag.SOFT_SYNC)) {
            boolean scheduledSync = !syncFlags.contains(SynchronizationFlag.WEBHOOK_SYNC);
            return new CapturingRepositorySync(this.eventService, repository, scheduledSync, this.threadEvents.startCapturing());
        }
        return NO_OP_REPO_SYNC;
    }
}

