/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.CarefulEventService;
import com.atlassian.jira.plugins.dvcs.event.ContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.EventService;
import com.atlassian.jira.plugins.dvcs.event.EventsFeature;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KillSwitchDecorator
implements CarefulEventService {
    private final EventsFeature eventsFeature;
    private final EventService delegate;

    @Autowired
    public KillSwitchDecorator(EventsFeature eventsFeature, EventService delegate) {
        this.eventsFeature = eventsFeature;
        this.delegate = delegate;
    }

    public void storeEvent(ContextAwareSyncEvent event) throws IllegalArgumentException {
        if (this.eventsFeature.isEnabled()) {
            this.delegate.storeEvent(event);
        }
    }

    public void dispatchEvents(Repository repository) {
        if (this.eventsFeature.isEnabled()) {
            this.delegate.dispatchEvents(repository);
        }
    }

    public void dispatchEvents(int repositoryId) {
        if (this.eventsFeature.isEnabled()) {
            this.delegate.dispatchEvents(repositoryId);
        }
    }

    public void discardEvents(Repository repository) {
        if (this.eventsFeature.isEnabled()) {
            this.delegate.discardEvents(repository);
        }
    }
}

