/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.dvcs.event.ContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.EventLimiter;
import com.atlassian.jira.plugins.dvcs.event.EventLimiterFactory;
import com.atlassian.jira.plugins.dvcs.event.EventService;
import com.atlassian.jira.plugins.dvcs.event.LimitExceededEvent;
import com.atlassian.jira.plugins.dvcs.event.SyncEvent;
import com.atlassian.jira.plugins.dvcs.event.SyncEventDao;
import com.atlassian.jira.plugins.dvcs.event.ThreadPoolUtil;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventServiceImpl
implements EventService {
    private static final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);
    private static final int DESTROY_TIMEOUT_SECS = 10;
    private final EventLimiterFactory eventLimiterFactory;
    private final EventPublisher eventPublisher;
    private final SyncEventDao syncEventDao;
    private final ThreadPoolExecutor eventDispatcher;

    @Autowired
    public EventServiceImpl(@ComponentImport EventPublisher eventPublisher, EventLimiterFactory eventLimiterFactory, SyncEventDao syncEventDao) {
        this(eventPublisher, syncEventDao, eventLimiterFactory, EventServiceImpl.createEventDispatcher());
    }

    @VisibleForTesting
    EventServiceImpl(@Nonnull EventPublisher eventPublisher, @Nonnull SyncEventDao syncEventDao, @Nonnull EventLimiterFactory eventLimiterFactory, @Nonnull ThreadPoolExecutor executorService) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.syncEventDao = (SyncEventDao)Preconditions.checkNotNull((Object)syncEventDao);
        this.eventLimiterFactory = (EventLimiterFactory)Preconditions.checkNotNull((Object)eventLimiterFactory);
        this.eventDispatcher = (ThreadPoolExecutor)Preconditions.checkNotNull((Object)executorService);
    }

    private static ThreadPoolExecutor createEventDispatcher() {
        return ThreadPoolUtil.newSingleThreadExecutor(ThreadFactories.named((String)"DVCSConnector.EventService").type(ThreadFactories.Type.DAEMON).build());
    }

    public void storeEvent(ContextAwareSyncEvent event) {
        this.syncEventDao.save(event);
    }

    public void dispatchEvents(Repository repository) {
        this.dispatch(new DispatchRequest(repository));
    }

    public void dispatchEvents(int repositoryId) {
        this.doDispatchEvents(new DispatchRequest(repositoryId, "repository with id " + repositoryId));
    }

    private void dispatch(DispatchRequest dispatchRequest) {
        this.eventDispatcher.submit(() -> {
            try {
                this.doDispatchEvents(dispatchRequest);
                return null;
            }
            catch (RuntimeException e) {
                logger.error("Error dispatching events for: " + dispatchRequest, (Throwable)e);
                throw new RuntimeException(e);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.destroyEventDispatcher();
    }

    private void doDispatchEvents(DispatchRequest dispatch) {
        EventLimiter limiter = this.eventLimiterFactory.create();
        AtomicInteger dispatched = new AtomicInteger(0);
        this.syncEventDao.foreachByRepoId(dispatch.repoId(), contextAwareEvent -> {
            if (Thread.interrupted()) {
                logger.error("Thread interrupted after dispatching {} events for: {}", (Object)dispatched.get(), (Object)dispatch);
                Thread.currentThread().interrupt();
                return;
            }
            try {
                SyncEvent event = contextAwareEvent.getSyncEvent();
                if (limiter.isLimitExceeded(event, contextAwareEvent.scheduledSync())) {
                    logger.debug("Limit exceeded, dropping event for repository {}: {}", (Object)dispatch, (Object)event);
                    return;
                }
                logger.debug("Publishing event for repository {}: {}", (Object)dispatch, (Object)event);
                this.eventPublisher.publish((Object)event);
                dispatched.incrementAndGet();
            }
            finally {
                this.syncEventDao.delete((ContextAwareSyncEvent)contextAwareEvent);
            }
        });
        int dropped = limiter.getLimitExceededCount();
        if (dropped > 0) {
            logger.info("Event limit exceeded for {}. Dropped {} subsequent events.", (Object)dispatch, (Object)dropped);
            this.eventPublisher.publish((Object)new LimitExceededEvent(dropped));
        }
    }

    public void discardEvents(Repository repository) {
        long deleted = this.syncEventDao.deleteAll(repository.getId());
        logger.debug("Deleted {} events from repo: {}", (Object)deleted, (Object)repository);
    }

    private void destroyEventDispatcher() {
        this.eventDispatcher.shutdown();
        this.eventDispatcher.getQueue().clear();
        try {
            boolean destroyed = this.eventDispatcher.awaitTermination(10L, TimeUnit.SECONDS);
            if (!destroyed) {
                logger.error("ExecutorService did not shut down within {}s", (Object)10);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while waiting for ExecutorService to shut down.");
            Thread.currentThread().interrupt();
        }
    }

    @Immutable
    private static class DispatchRequest {
        private final int repoId;
        private final String repoToString;

        public DispatchRequest(@Nonnull Repository repository) {
            this(repository.getId(), repository.toString());
        }

        private DispatchRequest(int repoId, String repoToString) {
            this.repoId = repoId;
            this.repoToString = repoToString;
        }

        public int repoId() {
            return this.repoId;
        }

        public String toString() {
            return String.format("Repository[%s]", this.repoToString);
        }
    }
}

