/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.EventLimit;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.sync.SyncConfig;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@AdminOnly
@Path(value="event/limits")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EventLimitsResource {
    private final SyncConfig syncConfig;

    public EventLimitsResource(SyncConfig syncConfig) {
        this.syncConfig = syncConfig;
    }

    @GET
    public Map<String, Integer> getAll() {
        HashMap limits = Maps.newHashMap();
        for (EventLimit limit : EventLimit.values()) {
            limits.put(limit.name(), this.syncConfig.getEffectiveLimit(limit));
        }
        return limits;
    }

    @PUT
    public Map<String, Integer> put(Map<String, Integer> newLimits) {
        Map<EventLimit, Integer> limitsToSet = this.validateNewLimits(newLimits);
        for (EventLimit limitType : limitsToSet.keySet()) {
            this.syncConfig.setEffectiveLimit(limitType, limitsToSet.get(limitType));
        }
        return this.getAll();
    }

    private Map<EventLimit, Integer> validateNewLimits(Map<String, Integer> newLimits) {
        HashMap limitsToUpdate = Maps.newHashMap();
        for (String name : newLimits.keySet()) {
            try {
                limitsToUpdate.put(EventLimit.valueOf((String)name), newLimits.get(name));
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException(Response.status((int)400).entity((Object)String.format("No such limit: %s", name)).build());
            }
        }
        return limitsToUpdate;
    }
}

