/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.EventLimit;
import com.atlassian.jira.plugins.dvcs.event.LimitedEvent;
import com.atlassian.jira.plugins.dvcs.event.SyncEvent;
import com.atlassian.jira.plugins.dvcs.sync.SyncConfig;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

class EventLimiter {
    private final SyncConfig syncConfig;
    private final LoadingCache<LimitKey, AtomicLong> remainingPermits = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<LimitKey, AtomicLong>(){

        public AtomicLong load(@Nonnull LimitKey key) throws Exception {
            long multiplier = !key.scheduledSync ? 1L : Math.min(60L, TimeUnit.MILLISECONDS.toMinutes(EventLimiter.this.syncConfig.scheduledSyncIntervalMillis()));
            return new AtomicLong(multiplier * (long)EventLimiter.this.syncConfig.getEffectiveLimit(key.eventLimit));
        }
    });

    public EventLimiter(SyncConfig syncConfig) {
        this.syncConfig = syncConfig;
    }

    public boolean isLimitExceeded(@Nonnull SyncEvent event, boolean scheduledSync) {
        if (event instanceof LimitedEvent) {
            AtomicLong remaining = (AtomicLong)this.remainingPermits.getUnchecked((Object)LimitKey.make((LimitedEvent)event, scheduledSync));
            return remaining.decrementAndGet() < 0L;
        }
        return false;
    }

    public int getLimitExceededCount() {
        int exceeded = 0;
        for (AtomicLong remaining : this.remainingPermits.asMap().values()) {
            exceeded = (int)((long)exceeded - Math.min(0L, remaining.get()));
        }
        return exceeded;
    }

    private static class LimitKey {
        @Nonnull
        private final EventLimit eventLimit;
        private final boolean scheduledSync;

        public LimitKey(EventLimit eventLimit, boolean scheduledSync) {
            this.eventLimit = (EventLimit)Preconditions.checkNotNull((Object)eventLimit);
            this.scheduledSync = scheduledSync;
        }

        public static LimitKey make(@Nonnull LimitedEvent event, boolean scheduledSync) {
            return new LimitKey(event.getEventLimit(), scheduledSync);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LimitKey limitKey = (LimitKey)o;
            if (this.scheduledSync != limitKey.scheduledSync) {
                return false;
            }
            return this.eventLimit == limitKey.eventLimit;
        }

        public int hashCode() {
            int result = this.eventLimit.hashCode();
            result = 31 * result + (this.scheduledSync ? 1 : 0);
            return result;
        }
    }
}

