/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.event;

import com.atlassian.jira.plugins.dvcs.event.CarefulEventService;
import com.atlassian.jira.plugins.dvcs.event.ContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.DefaultContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.RepositorySync;
import com.atlassian.jira.plugins.dvcs.event.SyncEvent;
import com.atlassian.jira.plugins.dvcs.event.ThreadEventsCaptor;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import java.util.Objects;
import javax.annotation.Nonnull;

class CapturingRepositorySync
implements RepositorySync {
    private final boolean scheduledSync;
    private final CarefulEventService eventService;
    private final Repository repository;
    private final ThreadEventsCaptor threadEventCaptor;

    CapturingRepositorySync(@Nonnull CarefulEventService eventService, @Nonnull Repository repository, boolean scheduledSync, @Nonnull ThreadEventsCaptor threadEventCaptor) {
        this.eventService = Objects.requireNonNull(eventService);
        this.repository = Objects.requireNonNull(repository);
        this.scheduledSync = scheduledSync;
        this.threadEventCaptor = Objects.requireNonNull(threadEventCaptor);
    }

    @Override
    public void finish() {
        try {
            this.storeEvents();
        }
        finally {
            this.threadEventCaptor.stopCapturing();
        }
    }

    private void storeEvents() {
        this.threadEventCaptor.processEach(SyncEvent.class, event -> this.eventService.storeEvent((ContextAwareSyncEvent)new DefaultContextAwareSyncEvent(this.repository.getId(), this.scheduledSync, event)));
    }
}

