/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.transform;

import com.atlassian.jira.plugins.dvcs.activity.PullRequestParticipantMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryCommitMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestMapping;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.PullRequestRef;
import com.atlassian.jira.plugins.dvcs.model.PullRequestStatus;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestTransformer {
    public static final Logger log = LoggerFactory.getLogger(PullRequestTransformer.class);
    private final RepositoryService repositoryService;

    public PullRequestTransformer(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public static String createRepositoryUrl(String hostUrl, String repositoryLabel) {
        if (repositoryLabel == null) {
            return null;
        }
        if (hostUrl != null && hostUrl.endsWith("/")) {
            hostUrl = hostUrl.substring(0, hostUrl.length() - 1);
        }
        return hostUrl + "/" + repositoryLabel;
    }

    public static String createRepositoryLabel(String orgName, String slug) {
        return orgName + "/" + slug;
    }

    public PullRequest transform(RepositoryPullRequestMapping pullRequestMapping, boolean withCommits) {
        if (pullRequestMapping == null) {
            return null;
        }
        Repository repository = this.repositoryService.get(pullRequestMapping.getToRepositoryId());
        PullRequest pullRequest = new PullRequest(pullRequestMapping.getID());
        pullRequest.setRemoteId(pullRequestMapping.getRemoteId().longValue());
        pullRequest.setRepositoryId(pullRequestMapping.getToRepositoryId());
        pullRequest.setName(pullRequestMapping.getName());
        pullRequest.setUrl(pullRequestMapping.getUrl());
        pullRequest.setSource(new PullRequestRef(pullRequestMapping.getSourceBranch(), pullRequestMapping.getSourceRepo(), PullRequestTransformer.createRepositoryUrl(repository.getOrgHostUrl(), pullRequestMapping.getSourceRepo())));
        pullRequest.setDestination(new PullRequestRef(pullRequestMapping.getDestinationBranch(), this.createRepositoryLabel(repository), repository.getRepositoryUrl()));
        pullRequest.setStatus(PullRequestStatus.fromRepositoryPullRequestMapping((String)pullRequestMapping.getLastStatus()));
        pullRequest.setCreatedOn(pullRequestMapping.getCreatedOn());
        pullRequest.setUpdatedOn(pullRequestMapping.getUpdatedOn());
        pullRequest.setAuthor(pullRequestMapping.getAuthor());
        pullRequest.setParticipants(this.transform(pullRequestMapping.getParticipants()));
        pullRequest.setCommentCount(pullRequestMapping.getCommentCount());
        if (withCommits) {
            pullRequest.setCommits(this.transform(pullRequestMapping.getCommits()));
        }
        pullRequest.setExecutedBy(pullRequestMapping.getExecutedBy());
        return pullRequest;
    }

    private List<Participant> transform(PullRequestParticipantMapping[] participantMappings) {
        if (participantMappings == null) {
            return null;
        }
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (PullRequestParticipantMapping participantMapping : participantMappings) {
            Participant participant = new Participant(participantMapping.getUsername(), participantMapping.isApproved(), participantMapping.getRole());
            participants.add(participant);
        }
        Collections.sort(participants, this.participantComparator());
        return participants;
    }

    @Nonnull
    private Comparator<Participant> participantComparator() {
        return new Comparator<Participant>(){

            @Override
            public int compare(Participant p1, Participant p2) {
                if (p1.getUsername() == null && p2.getUsername() == null) {
                    return 0;
                }
                if (p2.getUsername() == null) {
                    return -1;
                }
                if (p1.getUsername() == null) {
                    return 1;
                }
                return p1.getUsername().compareTo(p2.getUsername());
            }
        };
    }

    private List<Changeset> transform(RepositoryCommitMapping[] commitMappings) {
        if (commitMappings == null) {
            return null;
        }
        ArrayList<Changeset> commits = new ArrayList<Changeset>();
        for (RepositoryCommitMapping commitMapping : commitMappings) {
            Changeset changeset = new Changeset(0, commitMapping.getNode(), commitMapping.getMessage(), commitMapping.getDate());
            changeset.setAuthor(commitMapping.getAuthor());
            changeset.setRawAuthor(commitMapping.getRawAuthor());
            commits.add(changeset);
        }
        return commits;
    }

    private String createRepositoryLabel(Repository repository) {
        return PullRequestTransformer.createRepositoryLabel(repository.getOrgName(), repository.getSlug());
    }
}

