/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.transform;

import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageTagMapping;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.TransformUtils;
import com.atlassian.jira.plugins.dvcs.model.Message;
import com.atlassian.jira.plugins.dvcs.model.MessageQueueItem;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddressService;
import com.google.common.base.Preconditions;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class MessageEntityTransformer {
    private final MessageAddressService messageAddressService;

    @Inject
    public MessageEntityTransformer(MessageAddressService messageAddressService) {
        this.messageAddressService = (MessageAddressService)Preconditions.checkNotNull((Object)messageAddressService);
    }

    public Message toMessage(MessageMapping messageMapping) {
        Class payloadType = TransformUtils.transformPayloadStringToClass(messageMapping.getPayloadType());
        int retriesCount = 0;
        for (MessageQueueItemMapping queueItem : messageMapping.getQueuesItems()) {
            retriesCount = Math.max(retriesCount, queueItem.getRetriesCount());
        }
        Message message = new Message();
        message.setId(Integer.valueOf(messageMapping.getID()));
        message.setAddress(this.messageAddressService.get(payloadType, messageMapping.getAddress()));
        message.setPayload(messageMapping.getPayload());
        message.setPayloadType(payloadType);
        message.setPriority(messageMapping.getPriority());
        message.setTags(this.transformTags(messageMapping.getTags()));
        message.setRetriesCount(retriesCount);
        return message;
    }

    private String[] transformTags(MessageTagMapping[] rawTags) {
        return (String[])Stream.of(rawTags).map(MessageTagMapping::getTag).toArray(String[]::new);
    }

    public MessageQueueItem toMessageQueueItem(MessageQueueItemMapping mapping) {
        MessageQueueItem queueItem = new MessageQueueItem();
        queueItem.setId(mapping.getID());
        queueItem.setMessage(this.toMessage(mapping.getMessage()));
        queueItem.setRetryCount(mapping.getRetriesCount());
        queueItem.setLastFailed(mapping.getLastFailed());
        queueItem.setQueue(mapping.getQueue());
        queueItem.setState(mapping.getState());
        queueItem.setStateInfo(mapping.getStateInfo());
        return queueItem;
    }
}

