/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.transform;

import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.ChangesetDaoImpl;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFile;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetail;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetails;
import com.atlassian.jira.plugins.dvcs.model.FileData;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangesetTransformer {
    public static final Logger log = ExceptionLogger.getLogger(ChangesetTransformer.class);
    private final ChangesetDaoImpl changesetDao;
    @Autowired
    private OrganizationDao organizationDao;

    @Autowired
    public ChangesetTransformer(ChangesetDaoImpl changesetDao) {
        this.changesetDao = changesetDao;
    }

    public static List<ChangesetFileDetail> transfromFileData(FileData fileData) {
        LinkedList<ChangesetFileDetail> changesetFileDetails = new LinkedList<ChangesetFileDetail>();
        for (ChangesetFile file : fileData.getFiles()) {
            int additions = 0;
            int deletions = 0;
            if (file instanceof ChangesetFileDetail) {
                additions = ((ChangesetFileDetail)file).getAdditions();
                deletions = ((ChangesetFileDetail)file).getDeletions();
            }
            changesetFileDetails.add(new ChangesetFileDetail(file.getFileAction(), file.getFile(), additions, deletions));
        }
        return changesetFileDetails;
    }

    public static List<String> parseParentsData(String parentsData) {
        if ("<TOO_MANY_PARENTS>".equals(parentsData)) {
            return null;
        }
        ArrayList<String> parents = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)parentsData)) {
            return parents;
        }
        try {
            JSONArray parentsJson = new JSONArray(parentsData);
            for (int i = 0; i < parentsJson.length(); ++i) {
                parents.add(parentsJson.getString(i));
            }
        }
        catch (JSONException e) {
            log.info("Failed parsing parents from ParentsJson data.", (Throwable)e);
        }
        return parents;
    }

    public Changeset transform(ChangesetMapping changesetMapping, int mainRepositoryId, String dvcsType) {
        if (changesetMapping == null) {
            return null;
        }
        Changeset changeset = this.buildChangeSet(mainRepositoryId, changesetMapping, dvcsType);
        int firstRepository = 0;
        for (RepositoryMapping repositoryMapping : changesetMapping.getRepositories()) {
            Organization organization;
            if (repositoryMapping.isDeleted() || !repositoryMapping.isLinked() || !StringUtils.isEmpty((CharSequence)dvcsType) && !dvcsType.equals((organization = this.organizationDao.get(repositoryMapping.getOrganizationId())).getDvcsType())) continue;
            if (CollectionUtils.isEmpty((Collection)changeset.getRepositoryIds())) {
                firstRepository = repositoryMapping.getID();
            }
            if (changeset.getRepositoryId() == 0 && !repositoryMapping.isFork()) {
                changeset.setRepositoryId(repositoryMapping.getID());
            }
            changeset.getRepositoryIds().add(repositoryMapping.getID());
        }
        if (changeset.getRepositoryId() == 0) {
            changeset.setRepositoryId(firstRepository);
        }
        return CollectionUtils.isEmpty((Collection)changeset.getRepositoryIds()) ? null : changeset;
    }

    @VisibleForTesting
    Changeset buildChangeSet(int repositoryId, ChangesetMapping changesetMapping, String dvcsType) {
        if (changesetMapping == null) {
            return null;
        }
        List<ChangesetFileDetail> fileDetails = ChangesetFileDetails.fromJSON(changesetMapping.getFileDetailsJson());
        Changeset changeset = new Changeset(repositoryId, changesetMapping.getNode(), changesetMapping.getRawAuthor(), changesetMapping.getAuthor(), changesetMapping.getDate(), changesetMapping.getRawNode(), changesetMapping.getBranch(), changesetMapping.getMessage(), ChangesetTransformer.parseParentsData(changesetMapping.getParentsData()), (List)(fileDetails != null ? ImmutableList.copyOf(fileDetails) : null), changesetMapping.getFileCount(), changesetMapping.getAuthorEmail());
        changeset.setId(changesetMapping.getID());
        changeset.setVersion(changesetMapping.getVersion());
        changeset.setSmartcommitAvaliable(changesetMapping.isSmartcommitAvailable());
        changeset.setFileDetails(fileDetails);
        this.migrateChangesetFileData(changesetMapping, dvcsType, changeset);
        return changeset;
    }

    public void migrateChangesetFileData(ChangesetMapping changesetMapping, String dvcsType, Changeset changeset) {
        if (changesetMapping.getFilesData() != null) {
            if (changesetMapping.getFileCount() == 0) {
                FileData fileData = FileData.from(changesetMapping);
                log.debug("Migrating file count from old file data structure for changeset {}.", (Object)changeset.getNode());
                changeset.setAllFileCount(fileData.getFileCount());
                if ("bitbucket".equals(dvcsType) && fileData.getFileCount() == 6) {
                    log.debug("Forcing to refresh file details for changeset {}.", (Object)changeset.getNode());
                    changeset.setFileDetails(null);
                } else if (changeset.getFileDetails() == null && fileData.hasDetails()) {
                    log.debug("Migrating file details from old file data structure for changeset {}.", (Object)changeset.getNode());
                    changeset.setFileDetails(ChangesetTransformer.transfromFileData(fileData));
                }
            }
            this.changesetDao.update(changeset);
        }
    }
}

