/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.util.PseudoStream;
import com.atlassian.jira.plugins.dvcs.event.ContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.DefaultContextAwareSyncEvent;
import com.atlassian.jira.plugins.dvcs.event.SyncEvent;
import com.atlassian.jira.plugins.dvcs.event.SyncEventDao;
import com.atlassian.jira.plugins.dvcs.event.SyncEventMapping;
import com.atlassian.jira.plugins.dvcs.exception.InvalidSyncEventInDatabase;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QSyncEventMapping;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ParametersAreNonnullByDefault
public class SyncEventDaoQueryDsl
implements SyncEventDao {
    private static final int PAGE_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(SyncEventDaoQueryDsl.class);
    private final ActiveObjects ao;
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public SyncEventDaoQueryDsl(@ComponentImport ActiveObjects ao, DatabaseAccessor databaseAccessor) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
    }

    @Override
    public void save(ContextAwareSyncEvent event) {
        try {
            String json = event.asJson();
            this.ao.executeInTransaction(() -> (SyncEventMapping)this.ao.create(SyncEventMapping.class, (Map)ImmutableMap.of((Object)"REPO_ID", (Object)event.getRepoId(), (Object)"EVENT_DATE", (Object)event.getDate(), (Object)"EVENT_CLASS", (Object)event.getEventName(), (Object)"EVENT_JSON", (Object)json, (Object)"SCHEDULED_SYNC", (Object)event.scheduledSync())));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Event must be able to serialized to JSON", e);
        }
    }

    @Override
    public void delete(ContextAwareSyncEvent event) {
        int id = (Integer)event.getId().orElseThrow(() -> new IllegalArgumentException("event argument must have an Id"));
        this.databaseAccessor.runInTransaction(databaseConnection -> {
            QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
            return databaseConnection.delete((RelationalPath)qSyncEventMapping).where((Predicate)qSyncEventMapping.ID.eq((Object)id)).execute();
        });
    }

    @Override
    public long deleteAll(int repoId) {
        return (Long)this.databaseAccessor.runInTransaction(connection -> {
            QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
            return connection.delete((RelationalPath)qSyncEventMapping).where((Predicate)qSyncEventMapping.REPO_ID.eq((Object)repoId)).execute();
        });
    }

    @Override
    public void foreachByRepoId(int repoId, Consumer<ContextAwareSyncEvent> consumer) {
        PseudoStream.consumeAllInTable(() -> this.getStartingID(repoId), id -> this.getPageOfResults(repoId, (int)id), this::getMaxIdIfPresent, this::toContextAwareEvent, consumer);
    }

    @VisibleForTesting
    int getStartingID(int repoId) {
        Integer minSyncEventId = (Integer)this.databaseAccessor.runInTransaction(connection -> {
            QSyncEventMapping syncEvent = new QSyncEventMapping();
            return (Integer)((SQLQuery)((SQLQuery)connection.select((Expression)syncEvent.ID.min()).from((Expression)syncEvent)).where((Predicate)syncEvent.REPO_ID.eq((Object)repoId))).fetchFirst();
        });
        if (minSyncEventId == null) {
            return -1;
        }
        return minSyncEventId - 1;
    }

    private List<Tuple> getPageOfResults(int repoId, int maxIDinPreviousPage) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression[])qSyncEventMapping.all()).from((Expression)qSyncEventMapping)).where((Predicate)qSyncEventMapping.REPO_ID.eq((Object)repoId).and((Predicate)qSyncEventMapping.ID.gt((Number)maxIDinPreviousPage)))).limit(1000L)).orderBy(qSyncEventMapping.ID.asc())).fetch();
        });
    }

    private Optional<Integer> getMaxIdIfPresent(Collection<Tuple> results) {
        QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
        return results.stream().map(t -> (Integer)t.get(qSyncEventMapping.ID)).filter(Objects::nonNull).reduce(Integer::max);
    }

    private SyncEvent getSyncEventFromTuple(Tuple result) {
        QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
        String eventClassName = (String)result.get((Expression)qSyncEventMapping.EVENT_CLASS);
        String eventJson = (String)result.get((Expression)qSyncEventMapping.EVENT_JSON);
        try {
            Class<?> eventClass = Class.forName(eventClassName);
            return (SyncEvent)new ObjectMapper().readValue(eventJson, eventClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find the event class '{}'", (Object)eventClassName, (Object)e);
            throw new InvalidSyncEventInDatabase("Unable to find the class that was stored in event", e);
        }
        catch (IOException e) {
            log.error("Unable to parse the event JSON '{}'", (Object)eventJson, (Object)e);
            throw new InvalidSyncEventInDatabase("Unable convert the stored JSON back into a SyncEvent", e);
        }
    }

    private ContextAwareSyncEvent toContextAwareEvent(Tuple result) {
        QSyncEventMapping qSyncEventMapping = new QSyncEventMapping();
        int repoId = (Integer)Optional.ofNullable(result.get(qSyncEventMapping.REPO_ID)).orElseThrow(() -> new IllegalStateException(String.format("Null REPO_ID in '%s'", result)));
        return new DefaultContextAwareSyncEvent((Integer)result.get(qSyncEventMapping.ID), repoId, ((Boolean)Optional.ofNullable(result.get((Expression)qSyncEventMapping.SCHEDULED_SYNC)).orElse(false)).booleanValue(), this.getSyncEventFromTuple(result));
    }
}

