/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.DvcsTypeBooleanConditionFactory;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.IssueKeyPredicateFactory;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.PullRequestTransformer;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.RepositoryTransformer;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.PullRequestRef;
import com.atlassian.jira.plugins.dvcs.model.PullRequestStatus;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QOrganizationMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QPullRequestParticipantMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryPullRequestIssueKeyMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryPullRequestMapping;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PullRequestDaoQueryDsl {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public PullRequestDaoQueryDsl(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Nonnull
    public List<PullRequest> getByIssueKeys(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType) {
        Preconditions.checkNotNull(issueKeys);
        if (Iterables.isEmpty(issueKeys)) {
            return Collections.emptyList();
        }
        Tables tables = this.getAndInitTables();
        List<Tuple> rawPullRequests = this.getPullRequests(issueKeys, dvcsType, tables);
        List<PullRequest> pullRequests = this.transformToPullRequest(rawPullRequests, tables);
        if (!pullRequests.isEmpty()) {
            List<Tuple> pullRequestsData = this.getPullRequestsData(issueKeys, dvcsType, tables, pullRequests.get(pullRequests.size() - 1).getCreatedOn(), pullRequests.get(0).getCreatedOn());
            return this.populateAndFilterPullrequests(tables, pullRequests, pullRequestsData);
        }
        return pullRequests;
    }

    private Tables getAndInitTables() {
        Tables tables = new Tables();
        this.databaseAccessor.runInTransaction(connection -> {
            tables.inititalize();
            return Unit.Unit();
        });
        return tables;
    }

    private List<Tuple> getPullRequests(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType, @Nonnull Tables tables) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QRepositoryPullRequestMapping pullRequest = tables.getPrMapping();
            QRepositoryPullRequestMapping innerPullRequest = new QRepositoryPullRequestMapping();
            QRepositoryMapping repository = tables.getRepositoryMapping();
            QRepositoryMapping innerRepository = new QRepositoryMapping();
            QOrganizationMapping org = tables.getOrgMapping();
            QOrganizationMapping innerOrg = new QOrganizationMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{pullRequest.ID, pullRequest.TO_REPOSITORY_ID, pullRequest.REMOTE_ID, pullRequest.EXECUTED_BY, pullRequest.NAME, pullRequest.URL, pullRequest.LAST_STATUS, pullRequest.CREATED_ON, pullRequest.UPDATED_ON, pullRequest.AUTHOR, pullRequest.COMMENT_COUNT, pullRequest.SOURCE_BRANCH, pullRequest.SOURCE_REPO, org.HOST_URL, pullRequest.DESTINATION_BRANCH, org.NAME, repository.SLUG}).from((Expression)pullRequest)).join((EntityPath)repository)).on((Predicate)repository.ID.eq(pullRequest.TO_REPOSITORY_ID))).join((EntityPath)org)).on((Predicate)org.ID.eq(repository.ORGANIZATION_ID))).where((Predicate)pullRequest.ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(innerPullRequest.ID).from((Expression)innerPullRequest)).join((EntityPath)tables.getIssueMapping())).on((Predicate)innerPullRequest.ID.eq(tables.getIssueMapping().PULL_REQUEST_ID))).join((EntityPath)innerRepository)).on((Predicate)innerRepository.ID.eq(innerPullRequest.TO_REPOSITORY_ID))).join((EntityPath)innerOrg)).on((Predicate)innerOrg.ID.eq(innerRepository.ORGANIZATION_ID))).where((Predicate)innerRepository.DELETED.eq(Boolean.valueOf(false)).and((Predicate)innerRepository.LINKED.eq(Boolean.valueOf(true))).and(IssueKeyPredicateFactory.buildIssueKeyPredicate(issueKeys, tables.getIssueMapping())).and(DvcsTypeBooleanConditionFactory.getOrgDvcsTypeCondition(dvcsType)))))).orderBy(pullRequest.CREATED_ON.desc())).limit((long)DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY)).fetch();
        });
    }

    private List<Tuple> getPullRequestsData(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType, @Nonnull Tables tables, @Nonnull Date minDate, @Nonnull Date maxDate) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QRepositoryPullRequestMapping pullRequest = tables.getPrMapping();
            QRepositoryMapping repository = tables.getRepositoryMapping();
            QOrganizationMapping org = tables.getOrgMapping();
            QRepositoryPullRequestIssueKeyMapping issueMapping = tables.getIssueMapping();
            QPullRequestParticipantMapping participant = tables.getParticipantMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{pullRequest.ID, participant.USERNAME, participant.APPROVED, participant.ROLE, issueMapping.ISSUE_KEY}).from((Expression)pullRequest)).join((EntityPath)issueMapping)).on((Predicate)pullRequest.ID.eq(issueMapping.PULL_REQUEST_ID))).join((EntityPath)repository)).on((Predicate)repository.ID.eq(pullRequest.TO_REPOSITORY_ID))).join((EntityPath)org)).on((Predicate)org.ID.eq(repository.ORGANIZATION_ID))).leftJoin((EntityPath)participant)).on((Predicate)pullRequest.ID.eq(participant.PULL_REQUEST_ID))).where((Predicate)pullRequest.CREATED_ON.between((Comparable)minDate, (Comparable)maxDate).and((Predicate)repository.DELETED.eq(Boolean.valueOf(false))).and((Predicate)repository.LINKED.eq(Boolean.valueOf(true))).and(IssueKeyPredicateFactory.buildIssueKeyPredicate(issueKeys, issueMapping)).and(DvcsTypeBooleanConditionFactory.getOrgDvcsTypeCondition(dvcsType)))).orderBy(new OrderSpecifier[]{pullRequest.ID.asc(), participant.USERNAME.asc()})).fetch();
        });
    }

    private List<PullRequest> transformToPullRequest(Collection<Tuple> rawPullRequests, Tables tables) {
        return rawPullRequests.stream().map(t -> this.buildPullRequest((Tuple)t, tables)).collect(Collectors.toList());
    }

    private PullRequest buildPullRequest(@Nonnull Tuple tuple, @Nonnull Tables tables) {
        return PullRequest.newBuilder().withId(((Integer)tuple.get(tables.getPrMapping().ID)).intValue()).withRemoteId(((Long)Optional.ofNullable(tuple.get(tables.getPrMapping().REMOTE_ID)).orElse(-1L)).longValue()).withRepositoryId(((Integer)Optional.ofNullable(tuple.get(tables.getPrMapping().TO_REPOSITORY_ID)).orElse(-1)).intValue()).withName((String)tuple.get((Expression)tables.getPrMapping().NAME)).withUrl((String)tuple.get((Expression)tables.getPrMapping().URL)).withStatus(Optional.ofNullable(tuple.get((Expression)tables.getPrMapping().LAST_STATUS)).map(PullRequestStatus::fromRepositoryPullRequestMapping)).withCreatedOn((Date)tuple.get(tables.getPrMapping().CREATED_ON)).withUpdatedOn((Date)tuple.get(tables.getPrMapping().UPDATED_ON)).withAuthor((String)tuple.get((Expression)tables.getPrMapping().AUTHOR)).withCommentCount(((Integer)Optional.ofNullable(tuple.get(tables.getPrMapping().COMMENT_COUNT)).orElse(0)).intValue()).withExecutedBy((String)tuple.get((Expression)tables.getPrMapping().EXECUTED_BY)).withSource(this.getSourcePullRequestRef(tuple, tables)).withDestination(this.getDestinationPullRequestRef(tuple, tables)).build();
    }

    private List<PullRequest> populateAndFilterPullrequests(Tables tables, List<PullRequest> pullRequests, List<Tuple> pullRequestsData) {
        pullRequests.forEach(pullrequest -> pullRequestsData.stream().filter(data -> ((Integer)data.get(tables.getPrMapping().ID)).equals(pullrequest.getId())).forEach(data -> {
            this.addParticipant((PullRequest)pullrequest, (Tuple)data, tables);
            pullrequest.addIssueKeyIfAbsent((String)data.get((Expression)tables.getIssueMapping().ISSUE_KEY));
        }));
        return pullRequests.stream().filter(pr -> !pr.getIssueKeys().isEmpty()).collect(Collectors.toList());
    }

    private void addParticipant(@Nonnull PullRequest pullRequest, @Nonnull Tuple tuple, @Nonnull Tables tables) {
        String username = (String)tuple.get((Expression)tables.getParticipantMapping().USERNAME);
        Boolean approved = (Boolean)tuple.get((Expression)tables.getParticipantMapping().APPROVED);
        String role = (String)tuple.get((Expression)tables.getParticipantMapping().ROLE);
        if (username != null || approved != null || role != null) {
            Participant participant = new Participant(username, approved == null ? false : approved, role);
            if (pullRequest.getParticipants() == null) {
                pullRequest.setParticipants(new ArrayList());
            }
            if (!pullRequest.getParticipants().contains(participant)) {
                pullRequest.getParticipants().add(participant);
            }
        }
    }

    private PullRequestRef getSourcePullRequestRef(Tuple tuple, Tables tables) {
        String sourceBranch = (String)tuple.get((Expression)tables.getPrMapping().SOURCE_BRANCH);
        String sourceRepo = (String)tuple.get((Expression)tables.getPrMapping().SOURCE_REPO);
        String orgHostUrl = (String)tuple.get((Expression)tables.getOrgMapping().HOST_URL);
        return new PullRequestRef(sourceBranch, sourceRepo, PullRequestTransformer.createRepositoryUrl(orgHostUrl, sourceRepo));
    }

    private PullRequestRef getDestinationPullRequestRef(Tuple tuple, Tables tables) {
        String destinationBranch = (String)tuple.get((Expression)tables.getPrMapping().DESTINATION_BRANCH);
        String orgName = (String)tuple.get((Expression)tables.getOrgMapping().NAME);
        String slug = (String)tuple.get((Expression)tables.getRepositoryMapping().SLUG);
        String orgHostUrl = (String)tuple.get((Expression)tables.getOrgMapping().HOST_URL);
        String repositoryLabel = PullRequestTransformer.createRepositoryLabel(orgName, slug);
        String repositoryUrl = RepositoryTransformer.createRepositoryUrl(orgHostUrl, orgName, slug);
        return new PullRequestRef(destinationBranch, repositoryLabel, repositoryUrl);
    }

    private class Tables {
        private QRepositoryPullRequestMapping prMapping;
        private QRepositoryPullRequestIssueKeyMapping issueMapping;
        private QPullRequestParticipantMapping participantMapping;
        private QRepositoryMapping repositoryMapping;
        private QOrganizationMapping orgMapping;
        private boolean initialized = false;

        private Tables() {
        }

        public void inititalize() {
            this.prMapping = new QRepositoryPullRequestMapping();
            this.issueMapping = new QRepositoryPullRequestIssueKeyMapping();
            this.participantMapping = new QPullRequestParticipantMapping();
            this.repositoryMapping = new QRepositoryMapping();
            this.orgMapping = new QOrganizationMapping();
            this.initialized = true;
        }

        public QRepositoryPullRequestMapping getPrMapping() {
            this.checkIsInitialed();
            return this.prMapping;
        }

        public QRepositoryPullRequestIssueKeyMapping getIssueMapping() {
            this.checkIsInitialed();
            return this.issueMapping;
        }

        public QPullRequestParticipantMapping getParticipantMapping() {
            this.checkIsInitialed();
            return this.participantMapping;
        }

        public QRepositoryMapping getRepositoryMapping() {
            this.checkIsInitialed();
            return this.repositoryMapping;
        }

        public QOrganizationMapping getOrgMapping() {
            this.checkIsInitialed();
            return this.orgMapping;
        }

        private void checkIsInitialed() {
            if (!this.initialized) {
                throw new IllegalStateException("A call to initialize must be made before attempting to access the qBeans!");
            }
        }
    }
}

