/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.querydsl.v3.QIssueToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QOrganizationMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QOrganizationToProjectKeyMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryToChangesetMapping;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.google.common.base.Preconditions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class OrganizationQueryDslFacade {
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public OrganizationQueryDslFacade(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
    }

    public Collection<String> getAllProjectKeysFromChangesetsInOrganization(int orgId) {
        return (Collection)this.databaseAccessor.runInTransaction(connection -> {
            QIssueToChangesetMapping issueToChangesetMapping = new QIssueToChangesetMapping();
            QRepositoryToChangesetMapping repositoryToChangesetMapping = new QRepositoryToChangesetMapping();
            QRepositoryMapping repositoryMapping = new QRepositoryMapping();
            QOrganizationMapping organizationMapping = new QOrganizationMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)issueToChangesetMapping.PROJECT_KEY).from((Expression)issueToChangesetMapping)).join((EntityPath)repositoryToChangesetMapping)).on((Predicate)issueToChangesetMapping.CHANGESET_ID.eq(repositoryToChangesetMapping.CHANGESET_ID))).join((EntityPath)repositoryMapping)).on((Predicate)repositoryToChangesetMapping.REPOSITORY_ID.eq(repositoryMapping.ID))).join((EntityPath)organizationMapping)).on((Predicate)repositoryMapping.ORGANIZATION_ID.eq(organizationMapping.ID))).where((Predicate)organizationMapping.ID.eq((Object)orgId).and((Predicate)repositoryMapping.LINKED.eq(Boolean.valueOf(true))))).distinct()).fetch();
        });
    }

    public Iterable<String> getCurrentlyLinkedProjects(int orgId) {
        return (Iterable)this.databaseAccessor.runInTransaction(connection -> {
            QOrganizationToProjectKeyMapping organizationToProjectKeyMapping = new QOrganizationToProjectKeyMapping();
            QOrganizationMapping organizationMapping = new QOrganizationMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)organizationToProjectKeyMapping.PROJECT_KEY).from((Expression)organizationToProjectKeyMapping)).join((EntityPath)organizationMapping)).on((Predicate)organizationToProjectKeyMapping.ORGANIZATION_ID.eq(organizationMapping.ID))).where((Predicate)organizationMapping.ID.eq((Object)orgId))).distinct()).fetch();
        });
    }

    public long linkProject(int orgId, String projectKey) {
        return (Long)this.databaseAccessor.runInTransaction(connection -> {
            QOrganizationToProjectKeyMapping organizationToProjectKeyMapping = new QOrganizationToProjectKeyMapping();
            return connection.insert((RelationalPath)organizationToProjectKeyMapping).set(organizationToProjectKeyMapping.ORGANIZATION_ID, (Object)orgId).set((Path)organizationToProjectKeyMapping.PROJECT_KEY, (Object)projectKey).execute();
        });
    }

    public void updateLinkedProjects(int orgId, Iterable<String> newProjectKeys) {
        this.databaseAccessor.runInTransaction(connection -> {
            QOrganizationToProjectKeyMapping organizationToProjectKeyMapping = new QOrganizationToProjectKeyMapping();
            return connection.delete((RelationalPath)organizationToProjectKeyMapping).where((Predicate)organizationToProjectKeyMapping.ORGANIZATION_ID.eq((Object)orgId)).execute();
        });
        for (String newProjectKey : newProjectKeys) {
            this.linkProject(orgId, newProjectKey);
        }
    }

    public void remove(int organizationId) {
        this.databaseAccessor.runInTransaction(connection -> {
            QOrganizationToProjectKeyMapping organizationToProjectKeyMapping = new QOrganizationToProjectKeyMapping();
            QOrganizationMapping organizationMapping = new QOrganizationMapping();
            connection.delete((RelationalPath)organizationToProjectKeyMapping).where((Predicate)organizationToProjectKeyMapping.ORGANIZATION_ID.eq((Object)organizationId)).execute();
            return connection.delete((RelationalPath)organizationMapping).where((Predicate)organizationMapping.ID.eq((Object)organizationId)).execute();
        });
    }

    public void setLastPolled(int organizationId, long timestamp) {
        this.databaseAccessor.run(connection -> {
            QOrganizationMapping organizationMapping = new QOrganizationMapping();
            return connection.update((RelationalPath)organizationMapping).set(organizationMapping.LAST_POLLED, (Object)timestamp).where((Predicate)organizationMapping.ID.eq((Object)organizationId)).execute();
        });
    }

    public List<Integer> getAllOrganizationsWithEnabledRepos() {
        return (List)this.databaseAccessor.run(connection -> {
            QOrganizationMapping organizationMapping = new QOrganizationMapping();
            QRepositoryMapping repositoryMapping = new QRepositoryMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(organizationMapping.ID).from((Expression)organizationMapping)).join((EntityPath)repositoryMapping)).on((Predicate)organizationMapping.ID.eq(repositoryMapping.ORGANIZATION_ID))).where((Predicate)repositoryMapping.LINKED.eq(Boolean.valueOf(true)))).groupBy(organizationMapping.ID)).fetch();
        });
    }
}

