/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.dao.MessageQueueItemDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.MessageQueueItemAoDaoImpl;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.util.PseudoStream;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.MessageEntityTransformer;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.TransformUtils;
import com.atlassian.jira.plugins.dvcs.model.Message;
import com.atlassian.jira.plugins.dvcs.model.MessageId;
import com.atlassian.jira.plugins.dvcs.model.MessageQueueItem;
import com.atlassian.jira.plugins.dvcs.model.MessageState;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageTagMapping;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddressService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="MessageQueueItemDaoQueryDsl")
@ParametersAreNonnullByDefault
public class MessageQueueItemDaoQueryDsl
implements MessageQueueItemDao {
    private static final int PAGE_SIZE = 1000;
    private final DatabaseAccessor databaseAccessor;
    private final MessageAddressService messageAddressService;
    private final MessageEntityTransformer messageEntityTransformer;
    private final MessageQueueItemAoDaoImpl messageQueueAoDao;

    @Inject
    public MessageQueueItemDaoQueryDsl(DatabaseAccessor databaseAccessor, MessageAddressService messageAddressService, MessageEntityTransformer messageEntityTransformer, MessageQueueItemAoDaoImpl messageQueueAoDAO) {
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
        this.messageEntityTransformer = (MessageEntityTransformer)Preconditions.checkNotNull((Object)messageEntityTransformer);
        this.messageQueueAoDao = (MessageQueueItemAoDaoImpl)Preconditions.checkNotNull((Object)messageQueueAoDAO);
        this.messageAddressService = (MessageAddressService)Preconditions.checkNotNull((Object)messageAddressService);
    }

    @Override
    public MessageQueueItem create(Map<String, Object> queueItem) {
        return this.toMessageQueueItem(this.messageQueueAoDao.create(queueItem));
    }

    @Override
    public void save(MessageQueueItem messageQueueItem) {
        this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            return connection.update((RelationalPath)qMessageQueueItemMapping).set(qMessageQueueItemMapping.LAST_FAILED, (Object)messageQueueItem.getLastFailed()).set(qMessageQueueItemMapping.MESSAGE_ID, (Object)messageQueueItem.getMessage().getId()).set(qMessageQueueItemMapping.RETRIES_COUNT, (Object)messageQueueItem.getRetryCount()).set((Path)qMessageQueueItemMapping.STATE, (Object)messageQueueItem.getState()).set((Path)qMessageQueueItemMapping.STATE_INFO, (Object)messageQueueItem.getStateInfo()).set((Path)qMessageQueueItemMapping.QUEUE, (Object)messageQueueItem.getQueue()).where((Predicate)qMessageQueueItemMapping.ID.eq((Object)messageQueueItem.getId())).execute();
        });
    }

    @Override
    public void delete(MessageQueueItem messageQueueItem) {
        this.delete(messageQueueItem.getId());
    }

    @Override
    public void delete(int messageQueueItemId) {
        this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            return connection.delete((RelationalPath)qMessageQueueItemMapping).where((Predicate)qMessageQueueItemMapping.ID.eq((Object)messageQueueItemId)).execute();
        });
    }

    @Override
    @Nonnull
    public MessageQueueItem[] getByMessageId(MessageId messageId) {
        return (MessageQueueItem[])Stream.of(this.messageQueueAoDao.getByMessageId(messageId.getId())).map(this::toMessageQueueItem).toArray(MessageQueueItem[]::new);
    }

    @Override
    public Optional<MessageQueueItem> getQueueItemById(int id) {
        List<Tuple> results = this.getRawQueueItemByQueueItemID(id);
        if (results.size() > 0) {
            Map<Integer, Message> messageMap = this.getMessagesFromResult(results);
            return Optional.of(this.toMessageQueueItem(results.get(0), messageMap));
        }
        return Optional.empty();
    }

    @Override
    public Optional<MessageQueueItem> getByQueueAndMessage(String queue, int messageId) {
        MessageQueueItemMapping messageQueueItemMapping = this.messageQueueAoDao.getByQueueAndMessage(queue, messageId);
        if (Objects.nonNull(messageQueueItemMapping)) {
            return Optional.of(this.toMessageQueueItem(messageQueueItemMapping));
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public Message getNextItemForProcessing(String queue, String address) {
        MessageQueueItemMapping messageQueueItem = this.messageQueueAoDao.getNextItemForProcessing(queue, address);
        if (messageQueueItem == null) {
            return null;
        }
        return this.messageEntityTransformer.toMessage(messageQueueItem.getMessage());
    }

    @Override
    public void getByTagAndState(String tag, MessageState state, Consumer<Integer> consumer) {
        PseudoStream.consumeAllInTable(() -> this.getInitialIndexByTagAndState(tag, state), index -> this.getPageByTagAndState(tag, state, (int)index), PseudoStream::getMax, Function.identity(), consumer);
    }

    @Override
    public void getByState(MessageState state, Consumer<Integer> consumer) {
        PseudoStream.consumeAllInTable(() -> this.getInitialIndexByState(state), index -> this.getPageByState(state, (int)index), PseudoStream::getMax, Function.identity(), consumer);
    }

    private List<Integer> getPageByState(MessageState state, int startId) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(qMessageQueueItemMapping.ID).from((Expression)qMessageQueueItemMapping)).join((EntityPath)qMessageTagMapping)).on((Predicate)qMessageQueueItemMapping.MESSAGE_ID.eq(qMessageTagMapping.MESSAGE_ID))).where((Predicate)qMessageQueueItemMapping.STATE.eq((Object)state.name()).and((Predicate)qMessageQueueItemMapping.ID.gt((Number)startId)))).limit(1000L)).orderBy(qMessageQueueItemMapping.ID.asc())).fetch();
        });
    }

    private Integer getInitialIndexByState(MessageState state) {
        return (Integer)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            return ((SQLQuery)((SQLQuery)connection.select((Expression)qMessageQueueItemMapping.ID.min()).from((Expression)qMessageQueueItemMapping)).where((Predicate)qMessageQueueItemMapping.STATE.eq((Object)state.name()))).fetch().stream().map(Optional::ofNullable).findFirst().get().orElse(0) - 1;
        });
    }

    private List<Integer> getPageByTagAndState(String tag, MessageState state, int startId) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(qMessageQueueItemMapping.ID).from((Expression)qMessageQueueItemMapping)).join((EntityPath)qMessageTagMapping)).on((Predicate)qMessageQueueItemMapping.MESSAGE_ID.eq(qMessageTagMapping.MESSAGE_ID))).where((Predicate)qMessageQueueItemMapping.STATE.eq((Object)state.name()).and((Predicate)qMessageTagMapping.TAG.eq((Object)tag)).and((Predicate)qMessageQueueItemMapping.ID.gt((Number)startId)))).limit(1000L)).orderBy(qMessageQueueItemMapping.ID.asc())).fetch();
        });
    }

    private Integer getInitialIndexByTagAndState(String tag, MessageState state) {
        return (Integer)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)qMessageQueueItemMapping.ID.min()).from((Expression)qMessageQueueItemMapping)).join((EntityPath)qMessageTagMapping)).on((Predicate)qMessageQueueItemMapping.MESSAGE_ID.eq(qMessageTagMapping.MESSAGE_ID))).where((Predicate)qMessageQueueItemMapping.STATE.eq((Object)state.name()).and((Predicate)qMessageTagMapping.TAG.eq((Object)tag)))).fetch().stream().map(Optional::ofNullable).findFirst().get().orElse(0) - 1;
        });
    }

    private List<Tuple> getRawQueueItemByQueueItemID(int queueItemId) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            QMessageMapping qMessageMapping = new QMessageMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{qMessageQueueItemMapping.ID, qMessageQueueItemMapping.LAST_FAILED, qMessageQueueItemMapping.RETRIES_COUNT, qMessageQueueItemMapping.STATE, qMessageQueueItemMapping.STATE_INFO, qMessageQueueItemMapping.QUEUE, qMessageQueueItemMapping.MESSAGE_ID, qMessageMapping.ID, qMessageMapping.ADDRESS, qMessageMapping.PAYLOAD, qMessageMapping.PAYLOAD_TYPE, qMessageMapping.PRIORITY, qMessageTagMapping.ID, qMessageTagMapping.TAG}).from((Expression)qMessageQueueItemMapping)).join((EntityPath)qMessageTagMapping)).on((Predicate)qMessageQueueItemMapping.MESSAGE_ID.eq(qMessageTagMapping.MESSAGE_ID))).join((EntityPath)qMessageMapping)).on((Predicate)qMessageQueueItemMapping.MESSAGE_ID.eq(qMessageMapping.ID))).where((Predicate)qMessageQueueItemMapping.ID.eq((Object)queueItemId))).limit(1000L)).orderBy(qMessageQueueItemMapping.ID.asc())).fetch();
        });
    }

    @VisibleForTesting
    protected Map<Integer, Message> getMessagesFromResult(List<Tuple> results) {
        QMessageMapping qMessageMapping = new QMessageMapping();
        return results.stream().collect(Collectors.groupingBy(t -> (Integer)t.get(qMessageMapping.ID))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.flattenToMessage((Collection)entry.getValue())));
    }

    @VisibleForTesting
    protected MessageQueueItem toMessageQueueItem(MessageQueueItemMapping mapping) {
        MessageQueueItem queueItem = new MessageQueueItem();
        queueItem.setId(mapping.getID());
        queueItem.setMessage(this.messageEntityTransformer.toMessage(mapping.getMessage()));
        queueItem.setRetryCount(mapping.getRetriesCount());
        queueItem.setLastFailed(mapping.getLastFailed());
        queueItem.setQueue(mapping.getQueue());
        queueItem.setState(mapping.getState());
        queueItem.setStateInfo(mapping.getStateInfo());
        return queueItem;
    }

    @VisibleForTesting
    protected MessageQueueItem toMessageQueueItem(Tuple rawQueueResult, Map<Integer, Message> messages) {
        QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
        Integer id = (Integer)rawQueueResult.get(qMessageQueueItemMapping.ID);
        if (id == null) {
            throw new IllegalArgumentException("Null ID in database");
        }
        Integer retries = (Integer)rawQueueResult.get(qMessageQueueItemMapping.RETRIES_COUNT);
        if (retries == null) {
            throw new IllegalArgumentException("Null retires in database for message: " + id);
        }
        MessageQueueItem queueItem = new MessageQueueItem();
        queueItem.setId(id.intValue());
        queueItem.setMessage(messages.get(rawQueueResult.get(qMessageQueueItemMapping.MESSAGE_ID)));
        queueItem.setRetryCount(retries.intValue());
        queueItem.setLastFailed((Date)rawQueueResult.get(qMessageQueueItemMapping.LAST_FAILED));
        queueItem.setQueue((String)rawQueueResult.get((Expression)qMessageQueueItemMapping.QUEUE));
        queueItem.setState((String)rawQueueResult.get((Expression)qMessageQueueItemMapping.STATE));
        queueItem.setStateInfo((String)rawQueueResult.get((Expression)qMessageQueueItemMapping.STATE_INFO));
        return queueItem;
    }

    private <P extends HasProgress> Message<P> flattenToMessage(Collection<Tuple> allResults) {
        QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
        QMessageMapping qMessageMapping = new QMessageMapping();
        Tuple firstResult = allResults.stream().findFirst().get();
        Class payloadType = TransformUtils.transformPayloadStringToClass((String)firstResult.get((Expression)qMessageMapping.PAYLOAD_TYPE));
        int retriesCount = allResults.stream().map(t -> (Integer)t.get(qMessageQueueItemMapping.RETRIES_COUNT)).reduce(Integer::max).orElse(0);
        String address = (String)firstResult.get((Expression)qMessageMapping.ADDRESS);
        if (address == null) {
            throw new IllegalArgumentException("address was null for message " + firstResult.get(qMessageMapping.ID));
        }
        Integer priority = (Integer)firstResult.get(qMessageMapping.PRIORITY);
        if (priority == null) {
            throw new IllegalArgumentException("priority was null for message " + firstResult.get(qMessageMapping.ID));
        }
        Message message = new Message();
        message.setId((Integer)firstResult.get(qMessageMapping.ID));
        message.setAddress(this.messageAddressService.get(payloadType, address));
        message.setPayload((String)firstResult.get((Expression)qMessageMapping.PAYLOAD));
        message.setPayloadType(payloadType);
        message.setPriority(priority.intValue());
        message.setTags(this.getAllTags(allResults));
        message.setRetriesCount(retriesCount);
        return message;
    }

    private String[] getAllTags(Collection<Tuple> rawTags) {
        QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
        return (String[])rawTags.stream().map(t -> (String)t.get((Expression)qMessageTagMapping.TAG)).toArray(String[]::new);
    }
}

