/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.dao.MessageDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.MessageAoDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.util.PseudoStream;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.MessageEntityTransformer;
import com.atlassian.jira.plugins.dvcs.model.Message;
import com.atlassian.jira.plugins.dvcs.model.MessageId;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QMessageTagMapping;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.google.common.base.Preconditions;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ParametersAreNonnullByDefault
public class MessageDaoQueryDsl
implements MessageDao {
    private static final int PAGE_SIZE = 1000;
    private static final Logger log = LoggerFactory.getLogger(MessageDaoQueryDsl.class);
    private final MessageAoDao messageAoDao;
    private final MessageEntityTransformer messageEnitityTransformer;
    private final DatabaseAccessor databaseAccessor;

    @Inject
    public MessageDaoQueryDsl(DatabaseAccessor databaseAccessor, MessageAoDao messageAoDao, MessageEntityTransformer messageEnitityTransformer) {
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
        this.messageAoDao = (MessageAoDao)Preconditions.checkNotNull((Object)messageAoDao);
        this.messageEnitityTransformer = (MessageEntityTransformer)Preconditions.checkNotNull((Object)messageEnitityTransformer);
    }

    @Override
    @Nonnull
    public Message create(Map<String, Object> message, String[] tags) {
        return this.messageEnitityTransformer.toMessage(this.messageAoDao.create(message, tags));
    }

    @Override
    public void createTag(Message message, String tag) {
        this.messageAoDao.createTag(message.getId(), tag);
    }

    @Override
    public String[] getTags(MessageId messageId) {
        List tags = (List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            return ((SQLQuery)((SQLQuery)connection.select((Expression)qMessageTagMapping.TAG).from((Expression)qMessageTagMapping)).where((Predicate)qMessageTagMapping.MESSAGE_ID.eq((Object)messageId.getId()))).fetch();
        });
        return tags.toArray(new String[tags.size()]);
    }

    @Override
    public void delete(Message message) {
        this.databaseAccessor.runInTransaction(connection -> {
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            QMessageMapping qMessageMapping = new QMessageMapping();
            connection.delete((RelationalPath)qMessageTagMapping).where((Predicate)qMessageTagMapping.MESSAGE_ID.eq((Object)message.getId())).execute();
            return connection.delete((RelationalPath)qMessageMapping).where((Predicate)qMessageMapping.ID.eq((Object)message.getId())).execute();
        });
    }

    @Override
    public void deleteTag(Message message, String tag) {
        this.databaseAccessor.runInTransaction(connection -> {
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            return connection.delete((RelationalPath)qMessageTagMapping).where((Predicate)qMessageTagMapping.MESSAGE_ID.eq((Object)message.getId()).and((Predicate)qMessageTagMapping.TAG.eq((Object)tag))).execute();
        });
    }

    @Override
    @Nonnull
    public Message getById(int id) {
        return this.messageEnitityTransformer.toMessage(this.messageAoDao.getById(id));
    }

    @Override
    public int getMessagesForConsumingCount(String tag) {
        return this.messageAoDao.getMessagesForConsumingCount(tag);
    }

    @Override
    public void getByTag(String tag, Consumer<MessageId> messagesMappingConsumer) {
        PseudoStream.consumeAllInTable(() -> this.getInitialIndex(tag), id -> this.getPageOfResults(tag, (int)id), PseudoStream::getMax, MessageId::new, messagesMappingConsumer::accept);
    }

    private int getInitialIndex(String tag) {
        return ((List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageQueueItemMapping qMessageQueueItemMapping = new QMessageQueueItemMapping();
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            QMessageMapping qMessageMapping = new QMessageMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select((Expression)qMessageMapping.ID.min()).from((Expression)qMessageMapping)).leftJoin((EntityPath)qMessageTagMapping)).on((Predicate)qMessageMapping.ID.eq(qMessageTagMapping.MESSAGE_ID))).leftJoin((EntityPath)qMessageQueueItemMapping)).on((Predicate)qMessageMapping.ID.eq(qMessageQueueItemMapping.MESSAGE_ID))).where((Predicate)qMessageTagMapping.TAG.eq((Object)tag))).fetch();
        })).stream().map(Optional::ofNullable).findFirst().get().orElse(0) - 1;
    }

    private List<Integer> getPageOfResults(String tag, int initialIdForPage) {
        return (List)this.databaseAccessor.runInTransaction(connection -> {
            QMessageTagMapping qMessageTagMapping = new QMessageTagMapping();
            QMessageMapping qMessageMapping = new QMessageMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(qMessageMapping.ID).from((Expression)qMessageMapping)).limit(1000L)).leftJoin((EntityPath)qMessageTagMapping)).on((Predicate)qMessageMapping.ID.eq(qMessageTagMapping.MESSAGE_ID))).where((Predicate)qMessageTagMapping.TAG.eq((Object)tag).and((Predicate)qMessageMapping.ID.gt((Number)initialIdForPage)))).orderBy(qMessageMapping.ID.asc())).distinct()).fetch();
        });
    }
}

