/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.querydsl.v3.IssueKeyedMapping;
import com.atlassian.jira.plugins.dvcs.util.ActiveObjectsUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.atlassian.fugue.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class IssueKeyPredicateFactory {
    private IssueKeyPredicateFactory() {
    }

    @Nullable
    public static Predicate buildIssueKeyPredicate(@Nonnull Iterable<String> issueKeys, @Nonnull IssueKeyedMapping issueKeyedMapping) {
        ArrayList issueKeysList = Lists.newArrayList(issueKeys);
        if (issueKeysList.size() <= ActiveObjectsUtils.SQL_IN_CLAUSE_MAX) {
            return issueKeyedMapping.getIssueKeyExpression().in((Collection)issueKeysList);
        }
        List partititionedIssueKeys = Lists.partition((List)issueKeysList, (int)ActiveObjectsUtils.SQL_IN_CLAUSE_MAX);
        BooleanExpression issueKeyPredicate = issueKeyedMapping.getIssueKeyExpression().in((Collection)partititionedIssueKeys.get(0));
        for (List keys : Iterables.drop((int)1, (Iterable)partititionedIssueKeys)) {
            issueKeyPredicate = issueKeyPredicate.or((Predicate)issueKeyedMapping.getIssueKeyExpression().in((Collection)keys));
        }
        return issueKeyPredicate;
    }
}

