/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.dao.ChangesetDao;
import com.atlassian.jira.plugins.dvcs.dao.IssueToMappingFunction;
import com.atlassian.jira.plugins.dvcs.dao.impl.ChangesetDaoImpl;
import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.dao.impl.QueryDslFeatureHelper;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.DvcsTypeBooleanConditionFactory;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.IssueKeyPredicateFactory;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.ChangesetTransformer;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetail;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetails;
import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QChangesetMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QIssueToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QOrganizationMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryToChangesetMapping;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="changesetDaoQueryDsl")
public class ChangesetDaoQueryDsl
implements ChangesetDao {
    private final ChangesetDaoImpl changesetDao;
    private final DatabaseAccessor databaseAccessor;
    private final QueryDslFeatureHelper queryDslFeatureHelper;

    @Autowired
    public ChangesetDaoQueryDsl(DatabaseAccessor databaseAccessor, ChangesetDaoImpl changesetDao, QueryDslFeatureHelper queryDslFeatureHelper) {
        this.changesetDao = (ChangesetDaoImpl)Preconditions.checkNotNull((Object)changesetDao);
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
        this.queryDslFeatureHelper = (QueryDslFeatureHelper)Preconditions.checkNotNull((Object)queryDslFeatureHelper);
    }

    public void removeAllInRepository(int repositoryId) {
        this.changesetDao.removeAllInRepository(repositoryId);
    }

    public boolean createOrAssociate(Changeset changeset, Set<String> extractedIssues) {
        return this.changesetDao.createOrAssociate(changeset, extractedIssues);
    }

    public Changeset update(Changeset changeset) {
        return this.changesetDao.update(changeset);
    }

    public Changeset migrateFilesData(Changeset changeset, String dvcsType) {
        return this.changesetDao.migrateFilesData(changeset, dvcsType);
    }

    public Changeset getByNode(int repositoryId, String changesetNode) {
        return this.changesetDao.getByNode(repositoryId, changesetNode);
    }

    public List<Changeset> getByIssueKey(Iterable<String> issueKeys, boolean newestFirst) {
        return this.changesetDao.getByIssueKey(issueKeys, newestFirst);
    }

    public List<Changeset> getByRepository(int repositoryId) {
        return this.changesetDao.getByRepository(repositoryId);
    }

    public List<Changeset> getLatestChangesets(int maxResults, GlobalFilter gf) {
        return this.changesetDao.getLatestChangesets(maxResults, gf);
    }

    public int getNumberOfIssueKeysToChangeset() {
        return this.changesetDao.getNumberOfIssueKeysToChangeset();
    }

    public boolean forEachIssueKeyMapping(Organization organization, Repository repository, int pageSize, IssueToMappingFunction function) {
        return this.changesetDao.forEachIssueKeyMapping(organization, repository, pageSize, function);
    }

    public Set<String> findReferencedProjects(int repositoryId) {
        return this.changesetDao.findReferencedProjects(repositoryId);
    }

    public int getChangesetCount(int repositoryId) {
        return this.changesetDao.getChangesetCount(repositoryId);
    }

    public Set<String> findEmails(int repositoryId, String author) {
        return this.changesetDao.findEmails(repositoryId, author);
    }

    public List<Changeset> getByIssueKey(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType, boolean newestFirst) {
        if (this.queryDslFeatureHelper.isRetrievalUsingQueryDslDisabled()) {
            return this.changesetDao.getByIssueKey(issueKeys, dvcsType, newestFirst);
        }
        if (Iterables.isEmpty(issueKeys)) {
            return Collections.emptyList();
        }
        Tables tables = this.getAndInitTables();
        List<Tuple> changesets = this.getChangesets(issueKeys, dvcsType, newestFirst, tables);
        List<Changeset> changesetsByID = this.transformToChangeset(changesets, tables);
        if (!changesetsByID.isEmpty()) {
            int minDateIndex = newestFirst ? changesetsByID.size() - 1 : 0;
            int maxDateIndex = newestFirst ? 0 : changesetsByID.size() - 1;
            List<Tuple> changesetsData = this.getChangesetsData(issueKeys, dvcsType, tables, changesetsByID.get(minDateIndex).getDate(), changesetsByID.get(maxDateIndex).getDate());
            return this.populateAndFilterChangesets(tables, changesetsByID, changesetsData);
        }
        return changesetsByID;
    }

    private Tables getAndInitTables() {
        Tables tables = new Tables();
        this.databaseAccessor.run(connection -> {
            tables.initialize((DatabaseConnection)connection);
            return Unit.Unit();
        });
        return tables;
    }

    private List<Tuple> getChangesets(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType, boolean newestFirst, @Nonnull Tables tables) {
        return (List)this.databaseAccessor.run(connection -> {
            QChangesetMapping changeset = tables.getChangesetMapping();
            QChangesetMapping innerChangeset = new QChangesetMapping();
            QIssueToChangesetMapping issueToChangeset = tables.getIssueToChangesetMapping();
            QRepositoryToChangesetMapping rtcMapping = tables.getRtcMapping();
            QRepositoryMapping repository = tables.getRepositoryMapping();
            QOrganizationMapping org = tables.getOrgMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{changeset.FILE_DETAILS_JSON, changeset.NODE, changeset.RAW_AUTHOR, changeset.AUTHOR, changeset.DATE, changeset.RAW_NODE, changeset.BRANCH, changeset.MESSAGE, changeset.PARENTS_DATA, changeset.FILE_COUNT, changeset.AUTHOR_EMAIL, changeset.ID, changeset.VERSION, changeset.SMARTCOMMIT_AVAILABLE}).from((Expression)changeset)).where((Predicate)changeset.ID.in((SubQueryExpression)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)SQLExpressions.select(innerChangeset.ID).from((Expression)innerChangeset)).join((EntityPath)issueToChangeset)).on((Predicate)innerChangeset.ID.eq(issueToChangeset.CHANGESET_ID))).join((EntityPath)rtcMapping)).on((Predicate)innerChangeset.ID.eq(rtcMapping.CHANGESET_ID))).join((EntityPath)repository)).on((Predicate)repository.ID.eq(rtcMapping.REPOSITORY_ID))).join((EntityPath)org)).on((Predicate)org.ID.eq(repository.ORGANIZATION_ID))).where((Predicate)repository.DELETED.eq(Boolean.valueOf(false)).and((Predicate)repository.LINKED.eq(Boolean.valueOf(true))).and(IssueKeyPredicateFactory.buildIssueKeyPredicate(issueKeys, issueToChangeset)).and(DvcsTypeBooleanConditionFactory.getOrgDvcsTypeCondition(dvcsType)))))).orderBy(newestFirst ? changeset.DATE.desc() : changeset.DATE.asc())).limit((long)DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY)).fetch();
        });
    }

    private List<Tuple> getChangesetsData(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType, @Nonnull Tables tables, Date minDate, Date maxDate) {
        return (List)this.databaseAccessor.run(connection -> {
            QChangesetMapping changeset = tables.getChangesetMapping();
            QIssueToChangesetMapping issueToChangeset = tables.getIssueToChangesetMapping();
            QRepositoryToChangesetMapping rtcMapping = tables.getRtcMapping();
            QRepositoryMapping repository = tables.getRepositoryMapping();
            QOrganizationMapping org = tables.getOrgMapping();
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{changeset.ID, repository.ID, issueToChangeset.ISSUE_KEY}).from((Expression)changeset)).join((EntityPath)issueToChangeset)).on((Predicate)changeset.ID.eq(issueToChangeset.CHANGESET_ID))).join((EntityPath)rtcMapping)).on((Predicate)changeset.ID.eq(rtcMapping.CHANGESET_ID))).join((EntityPath)repository)).on((Predicate)repository.ID.eq(rtcMapping.REPOSITORY_ID))).join((EntityPath)org)).on((Predicate)org.ID.eq(repository.ORGANIZATION_ID))).where((Predicate)changeset.DATE.between((Comparable)minDate, (Comparable)maxDate).and((Predicate)repository.DELETED.eq(Boolean.valueOf(false))).and((Predicate)repository.LINKED.eq(Boolean.valueOf(true))).and(IssueKeyPredicateFactory.buildIssueKeyPredicate(issueKeys, issueToChangeset)).and(DvcsTypeBooleanConditionFactory.getOrgDvcsTypeCondition(dvcsType)))).fetch();
        });
    }

    private List<Changeset> transformToChangeset(List<Tuple> rawChangests, Tables tables) {
        return rawChangests.stream().map(t -> this.createChangeset((Tuple)t, tables)).collect(Collectors.toList());
    }

    private Changeset createChangeset(@Nonnull Tuple tuple, @Nonnull Tables tables) {
        List<ChangesetFileDetail> fileDetails = ChangesetFileDetails.fromJSON((String)tuple.get((Expression)tables.getChangesetMapping().FILE_DETAILS_JSON));
        return Changeset.newBuilder().withId(((Integer)tuple.get(tables.getChangesetMapping().ID)).intValue()).withNode((String)tuple.get((Expression)tables.getChangesetMapping().NODE)).withRawNode((String)tuple.get((Expression)tables.getChangesetMapping().RAW_NODE)).withAuthor((String)tuple.get((Expression)tables.getChangesetMapping().AUTHOR)).withAuthorEmail((String)tuple.get((Expression)tables.getChangesetMapping().AUTHOR_EMAIL)).withRawAuthor((String)tuple.get((Expression)tables.getChangesetMapping().RAW_AUTHOR)).withDate((Date)tuple.get(tables.getChangesetMapping().DATE)).withBranch((String)tuple.get((Expression)tables.getChangesetMapping().BRANCH)).withParents(ChangesetTransformer.parseParentsData((String)tuple.get((Expression)tables.getChangesetMapping().PARENTS_DATA))).withMessage((String)tuple.get((Expression)tables.getChangesetMapping().MESSAGE)).withFiles((Collection)(fileDetails != null ? ImmutableList.copyOf(fileDetails) : null)).withAllFileCount(((Integer)Optional.ofNullable(tuple.get(tables.getChangesetMapping().FILE_COUNT)).orElse(0)).intValue()).withVersion((Integer)tuple.get(tables.getChangesetMapping().VERSION)).withSmartcommitAvaliable((Boolean)tuple.get((Expression)tables.getChangesetMapping().SMARTCOMMIT_AVAILABLE)).build();
    }

    private List<Changeset> populateAndFilterChangesets(Tables tables, Collection<Changeset> changesetsByID, Collection<Tuple> changesetsData) {
        changesetsByID.forEach(changeset -> changesetsData.stream().filter(data -> ((Integer)data.get(((Tables)tables).changesetMapping.ID)).equals(changeset.getId())).forEach(data -> {
            Integer dataRepoId = (Integer)data.get(tables.getRepositoryMapping().ID);
            if (changeset.getRepositoryId() == 0) {
                changeset.setRepositoryId(dataRepoId.intValue());
            }
            changeset.addRepositoryIdIfAbsent(dataRepoId);
            String dataIssueKey = (String)data.get((Expression)tables.getIssueToChangesetMapping().ISSUE_KEY);
            changeset.addIssueKeyIfAbsent(dataIssueKey);
        }));
        return changesetsByID.stream().filter(changeset -> changeset.getRepositoryId() > 0).collect(Collectors.toList());
    }

    private class Tables {
        private QChangesetMapping changesetMapping;
        private QIssueToChangesetMapping issueToChangesetMapping;
        private QRepositoryToChangesetMapping rtcMapping;
        private QRepositoryMapping repositoryMapping;
        private QOrganizationMapping orgMapping;
        private boolean initialized = false;

        private Tables() {
        }

        public void initialize(DatabaseConnection connection) {
            this.changesetMapping = new QChangesetMapping();
            this.issueToChangesetMapping = new QIssueToChangesetMapping();
            this.rtcMapping = new QRepositoryToChangesetMapping();
            this.repositoryMapping = new QRepositoryMapping();
            this.orgMapping = new QOrganizationMapping();
            this.initialized = true;
        }

        public QChangesetMapping getChangesetMapping() {
            this.checkIsInitialed();
            return this.changesetMapping;
        }

        public QIssueToChangesetMapping getIssueToChangesetMapping() {
            this.checkIsInitialed();
            return this.issueToChangesetMapping;
        }

        public QRepositoryToChangesetMapping getRtcMapping() {
            this.checkIsInitialed();
            return this.rtcMapping;
        }

        public QRepositoryMapping getRepositoryMapping() {
            this.checkIsInitialed();
            return this.repositoryMapping;
        }

        public QOrganizationMapping getOrgMapping() {
            this.checkIsInitialed();
            return this.orgMapping;
        }

        private void checkIsInitialed() {
            if (!this.initialized) {
                throw new IllegalStateException("A call to initialize must be made before attempting to access the qBeans!");
            }
        }
    }
}

