/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl.querydsl;

import com.atlassian.jira.plugins.dvcs.dao.BranchDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.BranchDaoImpl;
import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.dao.impl.QueryDslFeatureHelper;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.DvcsTypeBooleanConditionFactory;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.IssueKeyPredicateFactory;
import com.atlassian.jira.plugins.dvcs.model.Branch;
import com.atlassian.jira.plugins.dvcs.model.BranchHead;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QBranchMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QIssueToBranchMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QOrganizationMapping;
import com.atlassian.jira.plugins.dvcs.querydsl.v3.QRepositoryMapping;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="branchDaoQueryDsl")
public class BranchDaoQueryDsl
implements BranchDao {
    private static final String ISSUE_COUNT = "issue_count";
    private static final String ISSUE_KEY = "ISSUE_KEY";
    private static Path<String> ISSUE_KEY_PATH = ExpressionUtils.path(String.class, (String)"ISSUE_KEY");
    private static Path<Long> ISSUE_COUNT_PATH = ExpressionUtils.path(Long.class, (String)"issue_count");
    private static final int PAGE_SIZE = 1000;
    private final BranchDaoImpl branchDao;
    private final QueryDslFeatureHelper queryDslFeatureHelper;
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public BranchDaoQueryDsl(@Nonnull BranchDaoImpl branchDao, @Nonnull DatabaseAccessor databaseAccessor, @Nonnull QueryDslFeatureHelper queryDslFeatureHelper) {
        this.databaseAccessor = (DatabaseAccessor)Preconditions.checkNotNull((Object)databaseAccessor);
        this.branchDao = (BranchDaoImpl)Preconditions.checkNotNull((Object)branchDao);
        this.queryDslFeatureHelper = (QueryDslFeatureHelper)Preconditions.checkNotNull((Object)queryDslFeatureHelper);
    }

    public void createBranchHead(int repositoryId, BranchHead branchHead) {
        this.branchDao.createBranchHead(repositoryId, branchHead);
    }

    public List<BranchHead> getBranchHeads(int repositoryId) {
        return this.branchDao.getBranchHeads(repositoryId);
    }

    public void removeBranchHead(int repositoryId, BranchHead branchHead) {
        this.branchDao.removeBranchHead(repositoryId, branchHead);
    }

    public void removeAllBranchHeadsInRepository(int repositoryId) {
        this.branchDao.removeAllBranchHeadsInRepository(repositoryId);
    }

    public List<Branch> getBranchesForIssue(Iterable<String> issueKeys) {
        return this.branchDao.getBranchesForIssue(issueKeys);
    }

    public List<Branch> getBranches(int repositoryId) {
        return this.branchDao.getBranches(repositoryId);
    }

    public void createBranch(int repositoryId, Branch branch, Set<String> issueKeys) {
        this.branchDao.createBranch(repositoryId, branch, issueKeys);
    }

    public void removeBranch(int repositoryId, Branch branch) {
        this.databaseAccessor.runInTransaction(connection -> {
            QBranchMapping branchMapping = new QBranchMapping();
            QIssueToBranchMapping issueMapping = new QIssueToBranchMapping();
            connection.delete((RelationalPath)issueMapping).where((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(branchMapping.ID).from((Expression)branchMapping)).where((Predicate)issueMapping.BRANCH_ID.eq(branchMapping.ID).and((Predicate)branchMapping.REPOSITORY_ID.eq((Object)repositoryId)).and((Predicate)branchMapping.NAME.eq((Object)branch.getName())))).exists()).execute();
            return connection.delete((RelationalPath)branchMapping).where((Predicate)branchMapping.REPOSITORY_ID.eq((Object)repositoryId).and((Predicate)branchMapping.NAME.eq((Object)branch.getName()))).execute();
        });
    }

    public void removeAllBranchesInRepository(int repositoryId) {
        this.databaseAccessor.runInTransaction(connection -> {
            QIssueToBranchMapping issueMapping = new QIssueToBranchMapping();
            QBranchMapping branchMapping = new QBranchMapping();
            connection.delete((RelationalPath)issueMapping).where((Predicate)((SQLQuery)((SQLQuery)SQLExpressions.select(branchMapping.ID).from((Expression)branchMapping)).where((Predicate)issueMapping.BRANCH_ID.eq(branchMapping.ID).and((Predicate)branchMapping.REPOSITORY_ID.eq((Object)repositoryId)))).exists()).execute();
            return connection.delete((RelationalPath)branchMapping).where((Predicate)branchMapping.REPOSITORY_ID.eq((Object)repositoryId)).execute();
        });
    }

    public List<Branch> getBranchesForRepository(int repositoryId) {
        return this.branchDao.getBranchesForRepository(repositoryId);
    }

    @Nonnull
    public List<Branch> getBranchesForIssue(@Nonnull Iterable<String> issueKeys, @Nullable String dvcsType) {
        if (Iterables.isEmpty(issueKeys)) {
            return Collections.emptyList();
        }
        if (this.queryDslFeatureHelper.isRetrievalUsingQueryDslDisabled()) {
            return this.branchDao.getBranchesForIssue(issueKeys, dvcsType);
        }
        Tables tables = this.fetchAndInitTables();
        List<Tuple> branchTuples = this.getBranches(issueKeys, dvcsType, tables);
        Map<Integer, Branch> branches = branchTuples.stream().map(tuple -> new Branch(((Integer)tuple.get(tables.getBranchMapping().ID)).intValue(), (String)tuple.get((Expression)tables.getBranchMapping().NAME), ((Integer)tuple.get(tables.getBranchMapping().REPOSITORY_ID)).intValue(), (Collection)ImmutableList.of((Object)tuple.get(ISSUE_KEY_PATH)))).collect(Collectors.toMap(Branch::getId, Function.identity()));
        List<Integer> branchIdsWithMoreCommits = branchTuples.stream().filter(t -> (Long)t.get(ISSUE_COUNT_PATH) != 1L).map(t -> (Integer)t.get(tables.getBranchMapping().ID)).collect(Collectors.toList());
        if (branchIdsWithMoreCommits.size() == 0) {
            return ImmutableList.copyOf(branches.values());
        }
        Map<Integer, List<String>> issueKeysForID = this.getAdditionalIssueKeys(branchIdsWithMoreCommits, tables).stream().collect(Collectors.groupingBy(tuple -> (Integer)tuple.get(tables.getIssueMapping().BRANCH_ID), Collectors.mapping(tuple -> (String)tuple.get((Expression)tables.getIssueMapping().ISSUE_KEY), Collectors.toList())));
        return this.addIssuesToBranches(branches, issueKeysForID);
    }

    private Tables fetchAndInitTables() {
        Tables tables = new Tables();
        this.databaseAccessor.run(connection -> {
            tables.initialize((DatabaseConnection)connection);
            return Unit.Unit();
        });
        return tables;
    }

    private List<Branch> addIssuesToBranches(Map<Integer, Branch> branchesById, Map<Integer, List<String>> issuesForBranches) {
        return branchesById.keySet().stream().map(branchId -> {
            HashSet issueKeys = new HashSet();
            issueKeys.addAll(((Branch)branchesById.get(branchId)).getIssueKeys());
            issueKeys.addAll((Collection)issuesForBranches.get(branchId));
            ((Branch)branchesById.get(branchId)).setIssueKeys((List)ImmutableList.copyOf(issueKeys));
            return (Branch)branchesById.get(branchId);
        }).collect(Collectors.toList());
    }

    private List<Tuple> getBranches(Iterable<String> issueKeys, String dvcsType, Tables tables) {
        return (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{tables.getBranchMapping().ID, tables.getBranchMapping().NAME, tables.getBranchMapping().REPOSITORY_ID, tables.getIssueMapping().ISSUE_KEY.max().as(ISSUE_KEY_PATH), SQLExpressions.countDistinct((Expression)tables.getIssueMapping().ISSUE_KEY).as(ISSUE_COUNT_PATH)}).from((Expression)tables.getBranchMapping())).join((EntityPath)tables.getIssueMapping())).on((Predicate)tables.getBranchMapping().ID.eq(tables.getIssueMapping().BRANCH_ID))).join((EntityPath)tables.getRepositoryMapping())).on((Predicate)tables.getRepositoryMapping().ID.eq(tables.getBranchMapping().REPOSITORY_ID))).join((EntityPath)tables.getOrgMapping())).on((Predicate)tables.getOrgMapping().ID.eq(tables.getRepositoryMapping().ORGANIZATION_ID))).where((Predicate)tables.getRepositoryMapping().DELETED.eq(Boolean.valueOf(false)).and((Predicate)tables.getRepositoryMapping().LINKED.eq(Boolean.valueOf(true))).and(IssueKeyPredicateFactory.buildIssueKeyPredicate(issueKeys, tables.getIssueMapping())).and(DvcsTypeBooleanConditionFactory.getOrgDvcsTypeCondition(dvcsType)))).groupBy(new Expression[]{tables.getBranchMapping().ID, tables.getBranchMapping().NAME, tables.getBranchMapping().REPOSITORY_ID})).orderBy(tables.getBranchMapping().NAME.asc())).limit((long)DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY)).fetch());
    }

    private List<Tuple> getAdditionalIssueKeys(List<Integer> branchIds, Tables tables) {
        return (List)this.databaseAccessor.run(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)connection.select(new Expression[]{tables.getIssueMapping().BRANCH_ID, tables.getIssueMapping().ISSUE_KEY}).from((Expression)tables.getIssueMapping())).where((Predicate)tables.getIssueMapping().BRANCH_ID.in((Collection)branchIds))).orderBy(tables.getIssueMapping().BRANCH_ID.asc())).fetch());
    }

    private class Tables {
        private QBranchMapping branchMapping;
        private QIssueToBranchMapping issueMapping;
        private QRepositoryMapping repositoryMapping;
        private QOrganizationMapping orgMapping;
        private boolean initialized = false;

        private Tables() {
        }

        public void initialize(DatabaseConnection connection) {
            this.branchMapping = new QBranchMapping();
            this.issueMapping = new QIssueToBranchMapping();
            this.repositoryMapping = new QRepositoryMapping();
            this.orgMapping = new QOrganizationMapping();
            this.initialized = true;
        }

        public QBranchMapping getBranchMapping() {
            this.checkIsInitialized();
            return this.branchMapping;
        }

        public QIssueToBranchMapping getIssueMapping() {
            this.checkIsInitialized();
            return this.issueMapping;
        }

        public QRepositoryMapping getRepositoryMapping() {
            this.checkIsInitialized();
            return this.repositoryMapping;
        }

        public QOrganizationMapping getOrgMapping() {
            this.checkIsInitialized();
            return this.orgMapping;
        }

        private void checkIsInitialized() {
            if (!this.initialized) {
                throw new IllegalStateException("A call to initialize must be made before attempting to access the qBeans!");
            }
        }
    }
}

