/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.SyncAuditLogMapping;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.dao.SyncAuditLogDao;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SyncAuditLogDaoImpl
implements SyncAuditLogDao {
    private static final int BIG_DATA_PAGESIZE = 200;
    private static final int ROTATION_PERIOD = 604800000;
    private static final Logger log = LoggerFactory.getLogger(SyncAuditLogDaoImpl.class);
    private final ActiveObjects ao;
    private final AnalyticsService analyticsService;

    @Inject
    @ParametersAreNonnullByDefault
    public SyncAuditLogDaoImpl(@ComponentImport ActiveObjects ao, AnalyticsService analyticsService) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
        this.analyticsService = (AnalyticsService)Preconditions.checkNotNull((Object)analyticsService);
    }

    private static Query pageQuery(Query q, Integer page) {
        q.setLimit(200);
        if (page == null) {
            q.setOffset(0);
        } else {
            q.setOffset(200 * page);
        }
        return q;
    }

    @Override
    public SyncAuditLogMapping newSyncAuditLog(int repoId, Set<SynchronizationFlag> flags, Date startDate) {
        return (SyncAuditLogMapping)this.ao.executeInTransaction(() -> {
            this.rotate(repoId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("REPO_ID", repoId);
            data.put("SYNC_TYPE", this.toSyncTypeString(flags));
            data.put("START_DATE", startDate);
            data.put("SYNC_STATUS", "RUNNING");
            data.put("TOTAL_ERRORS", 0);
            return (SyncAuditLogMapping)this.ao.create(SyncAuditLogMapping.class, data);
        });
    }

    private void rotate(int repoId) {
        Date maxStartDate = new Date(System.currentTimeMillis() - 604800000L);
        this.ao.deleteWithSQL(SyncAuditLogMapping.class, "REPO_ID = ? AND START_DATE < ?", new Object[]{repoId, maxStartDate});
    }

    private String toSyncTypeString(Iterable<SynchronizationFlag> flags) {
        StringBuilder bld = new StringBuilder();
        for (SynchronizationFlag flag : flags) {
            switch (flag) {
                case SOFT_SYNC: {
                    bld.append("SOFT").append(" ");
                    break;
                }
                case SYNC_CHANGESETS: {
                    bld.append("CHANGESETS").append(" ");
                    break;
                }
                case SYNC_PULL_REQUESTS: {
                    bld.append("PULLREQUESTS").append(" ");
                    break;
                }
                case WEBHOOK_SYNC: {
                    bld.append("WEBHOOKS").append(" ");
                    break;
                }
            }
        }
        return bld.toString();
    }

    @Override
    public void finish(int syncId, Date firstRequestDate, int numRequests, int flightTimeMs, Date finishDate) {
        this.ao.executeInTransaction(() -> {
            this.find(syncId).forEach(mapping -> {
                mapping.setFirstRequestDate(firstRequestDate);
                mapping.setEndDate(finishDate);
                mapping.setNumRequests(numRequests);
                mapping.setFlightTimeMs(flightTimeMs);
                if (StringUtils.isNotBlank((CharSequence)mapping.getExcTrace())) {
                    mapping.setSyncStatus("FAILED");
                } else {
                    mapping.setSyncStatus("SUCCESS");
                }
                mapping.save();
                this.analyticsService.publishRepositorySyncEnd(mapping.getID(), mapping.getEndDate(), mapping.getEndDate().getTime() - mapping.getStartDate().getTime());
            });
            return Unit.Unit();
        });
    }

    @Override
    public void pause(int syncId) {
        this.ao.executeInTransaction(() -> {
            this.find(syncId).forEach(mapping -> {
                mapping.setSyncStatus("SLEEPING");
                mapping.save();
            });
            return Unit.Unit();
        });
    }

    @Override
    public void resume(int syncId) {
        this.ao.executeInTransaction(() -> {
            this.find(syncId).filter(mapping -> "SLEEPING".equals(mapping.getSyncStatus())).forEach(mapping -> {
                mapping.setSyncStatus("RUNNING");
                mapping.save();
            });
            return Unit.Unit();
        });
    }

    @Override
    public int removeAllForRepo(int repoId) {
        return this.ao.deleteWithSQL(SyncAuditLogMapping.class, "REPO_ID = ?", new Object[]{repoId});
    }

    @Override
    public void setException(int syncId, Throwable throwable, boolean overwriteOld) {
        this.ao.executeInTransaction(() -> (Unit)this.find(syncId).fold(() -> {
            log.warn("No SyncAuditLogMapping with ID = {}", (Object)syncId);
            return Unit.Unit();
        }, mapping -> {
            boolean noExceptionYet = StringUtils.isBlank((CharSequence)mapping.getExcTrace());
            if (throwable != null && (overwriteOld || noExceptionYet)) {
                mapping.setExcTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
            mapping.setTotalErrors(mapping.getTotalErrors() + 1);
            mapping.save();
            return Unit.Unit();
        }));
    }

    @Override
    public SyncAuditLogMapping[] getAllForRepo(int repoId, Integer page) {
        return (SyncAuditLogMapping[])this.ao.executeInTransaction(() -> (SyncAuditLogMapping[])this.ao.find(SyncAuditLogMapping.class, this.repoQuery(repoId).page(page).order("START_DATE DESC")));
    }

    @Override
    public SyncAuditLogMapping[] getAll(Integer page) {
        return (SyncAuditLogMapping[])this.ao.executeInTransaction(() -> (SyncAuditLogMapping[])this.ao.find(SyncAuditLogMapping.class, SyncAuditLogDaoImpl.pageQuery(Query.select().order("START_DATE DESC"), page)));
    }

    private Option<SyncAuditLogMapping> find(int syncId) {
        return Option.option((Object)this.ao.get(SyncAuditLogMapping.class, (Object)syncId));
    }

    private PageableQuery repoQuery(int repoId) {
        return new PageableQuery(repoId);
    }

    class PageableQuery {
        private Query q;

        private PageableQuery(int repoId) {
            this.q = Query.select().from(SyncAuditLogMapping.class).where("REPO_ID = ?", new Object[]{repoId});
        }

        Query page(Integer page) {
            SyncAuditLogDaoImpl.pageQuery(this.q, page);
            return this.q;
        }
    }
}

