/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.activity.PullRequestParticipantMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryCommitMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryDomainMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestDao;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestIssueKeyMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestToCommitMapping;
import com.atlassian.jira.plugins.dvcs.dao.IssueToMappingFunction;
import com.atlassian.jira.plugins.dvcs.dao.ao.EntityBeanGenerator;
import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.sync.impl.IssueKeyExtractor;
import com.atlassian.jira.plugins.dvcs.util.ActiveObjectsUtils;
import com.atlassian.jira.plugins.dvcs.util.CustomStringUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryPullRequestDaoImpl
implements RepositoryPullRequestDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryPullRequestDaoImpl.class);
    private static final Iterable<Class<? extends RepositoryDomainMapping>> PR_ENTITIES = ImmutableSet.of(RepositoryPullRequestIssueKeyMapping.class, RepositoryPullRequestToCommitMapping.class, PullRequestParticipantMapping.class, RepositoryPullRequestMapping.class, RepositoryCommitMapping.class);
    private final ActiveObjects activeObjects;
    private final EntityBeanGenerator beanGenerator;

    @Autowired
    public RepositoryPullRequestDaoImpl(@ComponentImport ActiveObjects activeObjects, EntityBeanGenerator beanGenerator) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.beanGenerator = beanGenerator;
    }

    public void linkCommit(Repository domain, RepositoryPullRequestMapping request, RepositoryCommitMapping commit) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("DOMAIN_ID", domain.getId());
        params.put("REQUEST_ID", request.getID());
        params.put("COMMIT_ID", commit.getID());
        this.activeObjects.create(RepositoryPullRequestToCommitMapping.class, params);
    }

    public void unlinkCommits(Repository domain, RepositoryPullRequestMapping request, Iterable<? extends RepositoryCommitMapping> commits) {
        Iterable commitIds = StreamSupport.stream(commits.spliterator(), false).map(Entity::getID).collect(Collectors.toList());
        String baseWhereClause = ActiveObjectsUtils.renderListOperator((String)"COMMIT_ID", (String)"IN", (String)"OR", (Iterable)commitIds);
        this.activeObjects.deleteWithSQL(RepositoryPullRequestToCommitMapping.class, "REQUEST_ID = ? AND " + baseWhereClause, ObjectArrays.concat((Object)request.getID(), (Object[])Iterables.toArray((Iterable)commitIds, Object.class)));
    }

    public RepositoryPullRequestMapping createPullRequest() {
        return this.beanGenerator.createInstanceOf(RepositoryPullRequestMapping.class);
    }

    public void removeCommits(Iterable<? extends RepositoryCommitMapping> commits) {
        this.activeObjects.delete((RawEntity[])Iterables.toArray(commits, RepositoryCommitMapping.class));
    }

    public RepositoryPullRequestMapping savePullRequest(RepositoryPullRequestMapping pullRequest) {
        return this.doSavePullRequest(pullRequest.getDomainId(), RepositoryPullRequestDaoImpl.asMap(pullRequest));
    }

    private RepositoryPullRequestMapping doSavePullRequest(int repositoryId, Map<String, Object> request) {
        return (RepositoryPullRequestMapping)this.activeObjects.executeInTransaction(() -> {
            request.put("DOMAIN_ID", repositoryId);
            return (RepositoryPullRequestMapping)this.activeObjects.create(RepositoryPullRequestMapping.class, request);
        });
    }

    public RepositoryPullRequestMapping updatePullRequestInfo(int localId, RepositoryPullRequestMapping pullRequestMapping) {
        RepositoryPullRequestMapping request = this.findRequestById(localId);
        request.setName(CustomStringUtils.stripToLimit((String)pullRequestMapping.getName(), (int)255));
        request.setSourceBranch(pullRequestMapping.getSourceBranch());
        request.setDestinationBranch(pullRequestMapping.getDestinationBranch());
        request.setLastStatus(pullRequestMapping.getLastStatus());
        request.setSourceRepo(pullRequestMapping.getSourceRepo());
        request.setUpdatedOn(pullRequestMapping.getUpdatedOn());
        request.setCommentCount(pullRequestMapping.getCommentCount());
        request.setExecutedBy(pullRequestMapping.getExecutedBy());
        this.activeObjects.executeInTransaction(() -> {
            request.save();
            return null;
        });
        return request;
    }

    public int updatePullRequestIssueKeys(Repository domain, int pullRequestId) {
        RepositoryPullRequestMapping repositoryPullRequestMapping = this.findRequestById(pullRequestId);
        Set<String> existingIssueKeys = this.getIssueKeys(domain.getId(), pullRequestId);
        HashSet<String> currentIssueKeys = new HashSet<String>();
        currentIssueKeys.addAll(IssueKeyExtractor.extractIssueKeys(repositoryPullRequestMapping.getName(), repositoryPullRequestMapping.getSourceBranch()));
        for (RepositoryCommitMapping commit : repositoryPullRequestMapping.getCommits()) {
            if (commit.isMerge()) continue;
            currentIssueKeys.addAll(IssueKeyExtractor.extractIssueKeys(commit.getMessage()));
        }
        HashSet<String> addedIssueKeys = new HashSet<String>();
        addedIssueKeys.addAll(currentIssueKeys);
        addedIssueKeys.removeAll(existingIssueKeys);
        HashSet<String> removedIssueKeys = new HashSet<String>();
        removedIssueKeys.addAll(existingIssueKeys);
        removedIssueKeys.removeAll(currentIssueKeys);
        for (String issueKeyToAdd : addedIssueKeys) {
            Map<String, Object> issueKeyMapping = RepositoryPullRequestDaoImpl.asIssueKeyMapping(issueKeyToAdd, repositoryPullRequestMapping.getID());
            issueKeyMapping.put("DOMAIN_ID", domain.getId());
            this.activeObjects.create(RepositoryPullRequestIssueKeyMapping.class, issueKeyMapping);
        }
        for (String issueKeyToRemove : removedIssueKeys) {
            this.activeObjects.delete(this.activeObjects.find(RepositoryPullRequestIssueKeyMapping.class, Query.select().where("DOMAIN_ID = ? AND PULL_REQUEST_ID = ? AND ISSUE_KEY = ? ", new Object[]{domain.getId(), repositoryPullRequestMapping.getID(), issueKeyToRemove})));
        }
        return currentIssueKeys.size();
    }

    public Set<String> getIssueKeys(int repositoryId, int pullRequestId) {
        Query query = Query.select().from(RepositoryPullRequestIssueKeyMapping.class).where("DOMAIN_ID = ? AND PULL_REQUEST_ID = ? ", new Object[]{repositoryId, pullRequestId});
        RepositoryPullRequestIssueKeyMapping[] mappings = (RepositoryPullRequestIssueKeyMapping[])this.activeObjects.find(RepositoryPullRequestIssueKeyMapping.class, query);
        HashSet issueKeys = Sets.newHashSet();
        for (RepositoryPullRequestIssueKeyMapping mapping : mappings) {
            issueKeys.add(mapping.getIssueKey());
        }
        return issueKeys;
    }

    private static Map<String, Object> asIssueKeyMapping(String issueKey, int pullRequestId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ISSUE_KEY", issueKey);
        map.put("PULL_REQUEST_ID", pullRequestId);
        return map;
    }

    public RepositoryPullRequestMapping findRequestById(int localId) {
        return (RepositoryPullRequestMapping)this.activeObjects.get(RepositoryPullRequestMapping.class, (Object)localId);
    }

    public RepositoryPullRequestMapping findRequestByRemoteId(Repository domain, long remoteId) {
        Query query = Query.select().from(RepositoryPullRequestMapping.class).where("REMOTE_ID = ? AND DOMAIN_ID = ?", new Object[]{remoteId, domain.getId()});
        RepositoryPullRequestMapping[] found = (RepositoryPullRequestMapping[])this.activeObjects.find(RepositoryPullRequestMapping.class, query);
        return found.length == 1 ? found[0] : null;
    }

    public List<RepositoryPullRequestMapping> getByIssueKeys(Iterable<String> issueKeys) {
        Collection<Integer> prIds = this.findRelatedPullRequests(issueKeys);
        if (prIds.isEmpty()) {
            return Lists.newArrayList();
        }
        String whereClause = ActiveObjectsUtils.renderListOperator((String)"pr.ID", (String)"IN", (String)"OR", prIds);
        Object[] params = ObjectArrays.concat((Object[])new Object[]{Boolean.FALSE, Boolean.TRUE}, (Object[])prIds.toArray(), Object.class);
        Query select = Query.select().alias(RepositoryMapping.class, "repo").alias(RepositoryPullRequestMapping.class, "pr").join(RepositoryMapping.class, "repo.ID = pr.TO_REPOSITORY_ID").where("repo.DELETED = ? AND repo.LINKED = ? AND " + whereClause, params);
        return Arrays.asList(this.activeObjects.find(RepositoryPullRequestMapping.class, select));
    }

    public List<RepositoryPullRequestMapping> getByIssueKeys(Iterable<String> issueKeys, String dvcsType) {
        Collection<Integer> prIds = this.findRelatedPullRequests(issueKeys);
        if (prIds.isEmpty()) {
            return Lists.newArrayList();
        }
        String whereClause = ActiveObjectsUtils.renderListOperator((String)"pr.ID", (String)"IN", (String)"OR", prIds);
        Object[] params = ObjectArrays.concat((Object[])new Object[]{dvcsType, Boolean.FALSE, Boolean.TRUE}, (Object[])prIds.toArray(), Object.class);
        Query select = Query.select().alias(RepositoryMapping.class, "repo").alias(RepositoryPullRequestMapping.class, "pr").alias(OrganizationMapping.class, "org").join(RepositoryMapping.class, "repo.ID = pr.TO_REPOSITORY_ID").join(OrganizationMapping.class, "repo.ORGANIZATION_ID = org.ID").where("org.DVCS_TYPE = ? AND repo.DELETED = ? AND repo.LINKED = ? AND " + whereClause, params);
        return Arrays.asList(this.activeObjects.find(RepositoryPullRequestMapping.class, select));
    }

    private Collection<Integer> findRelatedPullRequests(Iterable<String> issueKeys) {
        return this.findRelatedPullRequestsObjects(issueKeys).stream().map(RepositoryPullRequestIssueKeyMapping::getPullRequestId).collect(Collectors.toList());
    }

    private List<RepositoryPullRequestIssueKeyMapping> findRelatedPullRequestsObjects(Iterable<String> issueKeys) {
        String whereClause = ActiveObjectsUtils.renderListOperator((String)"ISSUE_KEY", (String)"IN", (String)"OR", issueKeys);
        Query query = Query.select().from(RepositoryPullRequestIssueKeyMapping.class).where(whereClause, Iterables.toArray(issueKeys, Object.class)).order("PULL_REQUEST_ID").limit(DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY + 1);
        RepositoryPullRequestIssueKeyMapping[] mappings = (RepositoryPullRequestIssueKeyMapping[])this.activeObjects.find(RepositoryPullRequestIssueKeyMapping.class, query);
        return Arrays.asList(mappings);
    }

    public void removeAll(Repository repository) {
        PR_ENTITIES.forEach(entityType -> this.activeObjects.deleteWithSQL(entityType, "DOMAIN_ID = ? ", new Object[]{repository.getId()}));
    }

    public RepositoryCommitMapping saveCommit(Repository domain, Map<String, Object> commit) {
        return (RepositoryCommitMapping)this.activeObjects.executeInTransaction(() -> {
            commit.put("DOMAIN_ID", domain.getId());
            return (RepositoryCommitMapping)this.activeObjects.create(RepositoryCommitMapping.class, commit);
        });
    }

    public PullRequestParticipantMapping[] getParticipants(int pullRequestId) {
        return (PullRequestParticipantMapping[])this.activeObjects.find(PullRequestParticipantMapping.class, Query.select().where("PULL_REQUEST_ID = ?", new Object[]{pullRequestId}));
    }

    public void removeParticipant(PullRequestParticipantMapping participantMapping) {
        LOGGER.debug("deleting participant with id = [ {} ]", (Object)participantMapping.getID());
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.delete(new RawEntity[]{participantMapping});
            return null;
        });
    }

    public void saveParticipant(PullRequestParticipantMapping participantMapping) {
        LOGGER.debug("saving participant with id = [ {} ]", (Object)participantMapping.getID());
        this.activeObjects.executeInTransaction(() -> {
            participantMapping.save();
            return null;
        });
    }

    public void createParticipant(int pullRequestId, int repositoryId, Participant participant) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("USERNAME", participant.getUsername());
        params.put("APPROVED", participant.isApproved());
        params.put("ROLE", participant.getRole());
        params.put("PULL_REQUEST_ID", pullRequestId);
        params.put("DOMAIN_ID", repositoryId);
        this.activeObjects.create(PullRequestParticipantMapping.class, params);
    }

    public int getNumberOfIssueKeysToPullRequests() {
        Query query = Query.select((String)"ISSUE_KEY").from(RepositoryPullRequestIssueKeyMapping.class);
        return this.activeObjects.count(RepositoryPullRequestIssueKeyMapping.class, query);
    }

    public boolean forEachIssueKeyMapping(Organization organization, Repository repository, int pageSize, IssueToMappingFunction closure) {
        boolean result;
        RepositoryPullRequestIssueKeyMapping[] mappings;
        int currentPage = 0;
        int repositoryId = repository.getId();
        do {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Query issueQuery = Query.select().from(RepositoryPullRequestIssueKeyMapping.class).alias(RepositoryPullRequestIssueKeyMapping.class, "prik").alias(RepositoryPullRequestMapping.class, "pr").join(RepositoryPullRequestMapping.class, "prik.PULL_REQUEST_ID = pr.ID").alias(RepositoryMapping.class, "rm").join(RepositoryMapping.class, "rm.ID = pr.TO_REPOSITORY_ID").where("rm.ID = ?", new Object[]{repositoryId}).limit(pageSize).offset(currentPage * pageSize);
            mappings = (RepositoryPullRequestIssueKeyMapping[])this.activeObjects.find(RepositoryPullRequestIssueKeyMapping.class, issueQuery);
            Set issueKeys = Arrays.stream(mappings).map(RepositoryPullRequestIssueKeyMapping::getIssueKey).collect(Collectors.toSet());
            result = closure.execute(organization.getDvcsType(), repositoryId, issueKeys);
            LOGGER.info("processing page {} with this many elements {} took {} and had the result {}", new Object[]{++currentPage, issueKeys.size(), stopWatch, result});
        } while (mappings.length > 0 && result);
        return result;
    }

    private static Map<String, Object> asMap(RepositoryPullRequestMapping mapping) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("REMOTE_ID", mapping.getRemoteId());
        attributes.put("NAME", mapping.getName());
        attributes.put("URL", mapping.getUrl());
        attributes.put("TO_REPOSITORY_ID", mapping.getToRepositoryId());
        attributes.put("AUTHOR", mapping.getAuthor());
        attributes.put("EXECUTED_BY", mapping.getExecutedBy());
        attributes.put("CREATED_ON", mapping.getCreatedOn());
        attributes.put("UPDATED_ON", mapping.getUpdatedOn());
        attributes.put("DESTINATION_BRANCH", mapping.getDestinationBranch());
        attributes.put("SOURCE_BRANCH", mapping.getSourceBranch());
        attributes.put("LAST_STATUS", mapping.getLastStatus());
        attributes.put("SOURCE_REPO", mapping.getSourceRepo());
        attributes.put("COMMENT_COUNT", mapping.getCommentCount());
        return attributes;
    }
}

