/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryToProjectMapping;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.MapRemovingNullCharacterFromStringValues;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.RepositoryTransformer;
import com.atlassian.jira.plugins.dvcs.model.DefaultProgress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RepositoryDaoImpl
implements RepositoryDao {
    private static final Logger log = LoggerFactory.getLogger(RepositoryDaoImpl.class);
    private final ActiveObjects activeObjects;
    @Resource
    private RepositoryTransformer repositoryTransformer;
    @Resource
    private Synchronizer synchronizer;

    @Inject
    @ParametersAreNonnullByDefault
    public RepositoryDaoImpl(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
    }

    @ParametersAreNonnullByDefault
    public RepositoryDaoImpl(ActiveObjects activeObjects, RepositoryTransformer repositoryTransformer, Synchronizer synchronizer) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.synchronizer = (Synchronizer)Preconditions.checkNotNull((Object)synchronizer);
        this.repositoryTransformer = (RepositoryTransformer)Preconditions.checkNotNull((Object)repositoryTransformer);
    }

    @Nonnull
    private Repository transform(@Nonnull RepositoryMapping repositoryMapping) {
        OrganizationMapping organizationMapping = (OrganizationMapping)this.activeObjects.get(OrganizationMapping.class, (Object)repositoryMapping.getOrganizationId());
        DefaultProgress progress = (DefaultProgress)this.synchronizer.getProgress(repositoryMapping.getID());
        return this.repositoryTransformer.transform(repositoryMapping, organizationMapping, progress);
    }

    public List<Repository> getAllByOrganization(int organizationId, boolean includeDeleted) {
        Query query = Query.select();
        if (includeDeleted) {
            query.where("ORGANIZATION_ID = ? ", new Object[]{organizationId});
        } else {
            query.where("ORGANIZATION_ID = ? AND DELETED = ? ", new Object[]{organizationId, Boolean.FALSE});
        }
        query.order("NAME");
        return this.asRepositories((RepositoryMapping[])this.activeObjects.find(RepositoryMapping.class, query));
    }

    public Repository getByNameForOrganization(int organizationId, String repositoryName) {
        Query query = Query.select().where("ORGANIZATION_ID = ? AND DELETED = ? AND NAME = ?", new Object[]{organizationId, Boolean.FALSE, repositoryName});
        RepositoryMapping[] repositoryMappings = (RepositoryMapping[])this.activeObjects.find(RepositoryMapping.class, query);
        if (repositoryMappings == null || repositoryMappings.length == 0) {
            return null;
        }
        if (repositoryMappings.length > 1) {
            log.warn("Found {} repositories with name {} for organization {}.", new Object[]{repositoryMappings.length, repositoryName, organizationId});
        }
        return this.transform(repositoryMappings[0]);
    }

    public List<Repository> getAll(boolean includeDeleted) {
        Query select = Query.select();
        if (!includeDeleted) {
            select.where("DELETED = ? ", new Object[]{Boolean.FALSE});
        }
        select.order("NAME");
        return this.asRepositories((RepositoryMapping[])this.activeObjects.find(RepositoryMapping.class, select));
    }

    public List<Repository> getAllByType(String dvcsType, boolean includeDeleted) {
        Query select = Query.select().alias(OrganizationMapping.class, "org").alias(RepositoryMapping.class, "repo").join(OrganizationMapping.class, "repo.ORGANIZATION_ID = org.ID");
        if (!includeDeleted) {
            select.where("org.DVCS_TYPE = ? AND repo.DELETED = ? ", new Object[]{dvcsType, Boolean.FALSE});
        } else {
            select.where("org.DVCS_TYPE = ?", new Object[]{dvcsType});
        }
        return this.asRepositories((RepositoryMapping[])this.activeObjects.find(RepositoryMapping.class, select));
    }

    public List<String> getPreviouslyLinkedProjects(int repositoryId) {
        return Arrays.stream(this.activeObjects.find(RepositoryToProjectMapping.class, this.getQueryForProjectMappings(repositoryId))).map(RepositoryToProjectMapping::getProjectKey).collect(Collectors.toList());
    }

    public void setPreviouslyLinkedProjects(int repoId, Iterable<String> projectKeys) {
        this.activeObjects.deleteWithSQL(RepositoryToProjectMapping.class, "REPOSITORY_ID = ? ", new Object[]{repoId});
        projectKeys.forEach(projectKey -> this.associateProjectKey((String)projectKey, repoId));
    }

    private Query getQueryForProjectMappings(int forRepositoryId) {
        return Query.select().alias(RepositoryMapping.class, "repo").alias(RepositoryToProjectMapping.class, "proj").join(RepositoryMapping.class, "proj.REPOSITORY_ID = repo.ID").where("repo.ID = " + forRepositoryId, new Object[0]);
    }

    private void associateProjectKey(String projectKey, int repositoryId) {
        this.activeObjects.executeInTransaction(() -> {
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("PROJECT_KEY", projectKey);
            map.put("REPOSITORY_ID", repositoryId);
            RepositoryToProjectMapping mapping = (RepositoryToProjectMapping)this.activeObjects.create(RepositoryToProjectMapping.class, (Map)map);
            mapping.save();
            return mapping;
        });
    }

    public boolean existsLinkedRepositories(boolean includeDeleted) {
        Query query = Query.select();
        if (includeDeleted) {
            query.where("LINKED = ?", new Object[]{Boolean.TRUE});
        } else {
            query.where("LINKED = ? AND DELETED = ? ", new Object[]{Boolean.TRUE, Boolean.FALSE});
        }
        return this.activeObjects.count(RepositoryMapping.class, query) > 0;
    }

    private List<Repository> asRepositories(RepositoryMapping[] repositoryMappings) {
        return Arrays.stream(repositoryMappings).map(this::transform).collect(Collectors.toList());
    }

    @Nullable
    public Repository get(int repositoryId) {
        RepositoryMapping repositoryMapping = (RepositoryMapping)this.activeObjects.executeInTransaction(() -> (RepositoryMapping)this.activeObjects.get(RepositoryMapping.class, (Object)repositoryId));
        if (repositoryMapping == null) {
            log.warn("Repository with id {} was not found.", (Object)repositoryId);
            return null;
        }
        return this.transform(repositoryMapping);
    }

    @Nonnull
    public Repository save(@Nonnull Repository repository) {
        RepositoryMapping repositoryMapping = (RepositoryMapping)this.activeObjects.executeInTransaction(() -> {
            if (repository.getId() == 0) {
                RepositoryMapping newMapping = this.insertRepositoryMapping(repository);
                return ((RepositoryMapping[])this.activeObjects.find(RepositoryMapping.class, "ID = ?", new Object[]{newMapping.getID()}))[0];
            }
            return this.updateRepositoryMapping(repository);
        });
        return this.transform(repositoryMapping);
    }

    private RepositoryMapping insertRepositoryMapping(Repository repository) {
        MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
        map.put("ORGANIZATION_ID", repository.getOrganizationId());
        map.put("SLUG", repository.getSlug());
        map.put("NAME", repository.getName());
        map.put("LAST_COMMIT_DATE", repository.getLastCommitDate());
        map.put("LINKED", repository.isLinked());
        map.put("DELETED", repository.isDeleted());
        map.put("SMARTCOMMITS_ENABLED", repository.isSmartcommitsEnabled());
        map.put("ACTIVITY_LAST_SYNC", repository.getActivityLastSync());
        map.put("LOGO", repository.getLogo());
        map.put("FORK", repository.isFork());
        map.put("UPDATE_LINK_AUTHORISED", repository.isUpdateLinkAuthorised());
        if (repository.getForkOf() != null) {
            map.put("FORK_OF_NAME", repository.getForkOf().getName());
            map.put("FORK_OF_SLUG", repository.getForkOf().getSlug());
            map.put("FORK_OF_OWNER", repository.getForkOf().getOwner());
        }
        return (RepositoryMapping)this.activeObjects.create(RepositoryMapping.class, (Map)map);
    }

    private RepositoryMapping updateRepositoryMapping(Repository repository) {
        RepositoryMapping rm = (RepositoryMapping)this.activeObjects.get(RepositoryMapping.class, (Object)repository.getId());
        rm.setSlug(repository.getSlug());
        rm.setName(repository.getName());
        rm.setLastCommitDate(repository.getLastCommitDate());
        rm.setLinked(repository.isLinked());
        rm.setDeleted(repository.isDeleted());
        rm.setSmartcommitsEnabled(repository.isSmartcommitsEnabled());
        rm.setActivityLastSync(repository.getActivityLastSync());
        rm.setLogo(repository.getLogo());
        rm.setFork(repository.isFork());
        rm.setUpdateLinkAuthorised(repository.isUpdateLinkAuthorised());
        if (repository.getForkOf() != null) {
            rm.setForkOfName(repository.getForkOf().getName());
            rm.setForkOfSlug(repository.getForkOf().getSlug());
            rm.setForkOfOwner(repository.getForkOf().getOwner());
        } else {
            rm.setForkOfName(null);
            rm.setForkOfSlug(null);
            rm.setForkOfOwner(null);
        }
        rm.save();
        return rm;
    }

    public void remove(int repositoryId) {
        this.activeObjects.executeInTransaction(() -> {
            this.deleteChildRows(RepositoryToProjectMapping.class, "REPOSITORY_ID", repositoryId);
            this.activeObjects.delete(new RawEntity[]{this.activeObjects.get(RepositoryMapping.class, (Object)repositoryId)});
            return null;
        });
    }

    private void deleteChildRows(Class<? extends Entity> childTable, String fkColumn, int repositoryId) {
        this.activeObjects.deleteWithSQL(childTable, fkColumn + " = ?", new Object[]{repositoryId});
    }

    public void setLastActivitySyncDate(Integer repositoryId, Date date) {
        this.activeObjects.executeInTransaction(() -> {
            RepositoryMapping repo = (RepositoryMapping)this.activeObjects.get(RepositoryMapping.class, (Object)repositoryId);
            repo.setActivityLastSync(date);
            repo.save();
            return null;
        });
    }
}

