/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.crypto.Encryptor;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationAOFacade;
import com.atlassian.jira.plugins.dvcs.dao.impl.MapRemovingNullCharacterFromStringValues;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.BasicAuthCredential;
import com.atlassian.jira.plugins.dvcs.model.credential.Credential;
import com.atlassian.jira.plugins.dvcs.model.credential.CredentialFactory;
import com.atlassian.jira.plugins.dvcs.model.credential.CredentialVisitor;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.jira.plugins.dvcs.model.credential.ThreeLeggedOAuthCredential;
import com.atlassian.jira.plugins.dvcs.model.credential.TwoLeggedOAuthCredential;
import com.atlassian.jira.plugins.dvcs.model.credential.UnauthenticatedCredential;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="organizationAOFacade")
public class OrganizationAOFacadeImpl
implements OrganizationAOFacade {
    public static final Logger log = LoggerFactory.getLogger(OrganizationAOFacadeImpl.class);
    private final ActiveObjects activeObjects;
    private final Encryptor encryptor;

    @Inject
    public OrganizationAOFacadeImpl(@ComponentImport @Nonnull ActiveObjects activeObjects, @Nonnull Encryptor encryptor) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.encryptor = (Encryptor)Preconditions.checkNotNull((Object)encryptor);
    }

    @VisibleForTesting
    Organization transform(@Nullable OrganizationMapping mapping) {
        if (mapping == null) {
            return null;
        }
        Credential credential = CredentialFactory.buildCredential().setKey(mapping.getOauthKey()).setSecret(mapping.getOauthSecret()).setToken(mapping.getAccessToken()).setUsername(mapping.getAdminUsername()).setPassword(mapping.getAdminPassword()).setPrincipalId(mapping.getPrincipalId()).build();
        Organization result = new Organization(mapping.getID(), mapping.getHostUrl(), mapping.getName(), mapping.getDvcsType(), mapping.isAutolinkNewRepos(), credential, this.createOrganizationUrl(mapping), mapping.isSmartcommitsForNewRepos(), this.deserializeDefaultGroups(mapping.getDefaultGroupsSlugs()), mapping.getLastPolled());
        if (StringUtils.isNotBlank((CharSequence)mapping.getApprovalState())) {
            result.setApprovalState(Organization.ApprovalState.valueOf((String)mapping.getApprovalState()));
        }
        return result;
    }

    protected Set<Group> deserializeDefaultGroups(String defaultGroupsSlugs) {
        HashSet<Group> slugs = new HashSet<Group>();
        if (StringUtils.isNotBlank((CharSequence)defaultGroupsSlugs)) {
            Iterable groupsSlugs = Splitter.on((String)";").split((CharSequence)defaultGroupsSlugs);
            for (String slug : groupsSlugs) {
                if (!StringUtils.isNotBlank((CharSequence)slug)) continue;
                slugs.add(new Group(StringUtils.trim((String)slug)));
            }
        }
        return slugs;
    }

    protected String serializeDefaultGroups(Set<Group> groups) {
        if (CollectionUtils.isEmpty(groups)) {
            return "";
        }
        return Joiner.on((String)";").join(groups);
    }

    private String createOrganizationUrl(OrganizationMapping organizationMapping) {
        String hostUrl = organizationMapping.getHostUrl();
        if (hostUrl != null && hostUrl.endsWith("/")) {
            hostUrl = hostUrl.substring(0, hostUrl.length() - 1);
        }
        return hostUrl + "/" + organizationMapping.getName();
    }

    @Override
    public List<Organization> fetch() {
        List organizationMappings = (List)this.activeObjects.executeInTransaction(() -> Lists.newArrayList((Object[])this.activeObjects.find(OrganizationMapping.class, Query.select().order("NAME"))));
        return this.transformCollection(organizationMappings);
    }

    private List<Organization> transformCollection(List<OrganizationMapping> organizationMappings) {
        return (List)CollectionUtils.collect(organizationMappings, input -> {
            OrganizationMapping organizationMapping = (OrganizationMapping)input;
            return this.transform(organizationMapping);
        });
    }

    @Override
    public Organization save(Organization organization) {
        OrganizationMapping organizationMapping = (OrganizationMapping)this.activeObjects.executeInTransaction(() -> {
            OrganizationMapping om = null;
            if (organization.getId() == 0) {
                MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
                map.put("HOST_URL", organization.getHostUrl());
                map.put("NAME", organization.getName());
                map.put("DVCS_TYPE", organization.getDvcsType());
                map.put("AUTOLINK_NEW_REPOS", organization.isAutolinkNewRepos());
                map.put("SMARTCOMMITS_FOR_NEW_REPOS", organization.isSmartcommitsOnNewRepos());
                map.put("DEFAULT_GROUPS_SLUGS", this.serializeDefaultGroups(organization.getDefaultGroups()));
                map.put("APPROVAL_STATE", organization.getApprovalState().name());
                map.putAll((Map)organization.getCredential().accept((CredentialVisitor)new CredentialDBFieldVisitor(organization, this.encryptor)));
                om = (OrganizationMapping)this.activeObjects.create(OrganizationMapping.class, (Map)map);
                om = ((OrganizationMapping[])this.activeObjects.find(OrganizationMapping.class, "ID = ?", new Object[]{om.getID()}))[0];
            } else {
                om = (OrganizationMapping)this.activeObjects.get(OrganizationMapping.class, (Object)organization.getId());
                om.setHostUrl(organization.getHostUrl());
                om.setName(organization.getName());
                om.setDvcsType(organization.getDvcsType());
                om.setAutolinkNewRepos(organization.isAutolinkNewRepos());
                om.setSmartcommitsForNewRepos(organization.isSmartcommitsOnNewRepos());
                om.setDefaultGroupsSlugs(this.serializeDefaultGroups(organization.getDefaultGroups()));
                om.setApprovalState(organization.getApprovalState().name());
                organization.getCredential().accept((CredentialVisitor)new OrganizationPopulatorVisitor(om));
                om.save();
            }
            return om;
        });
        return this.transform(organizationMapping);
    }

    @Override
    public void updateDefaultGroupsSlugs(int orgId, Collection<String> groupsSlugs) {
        String serializedGroups = null;
        if (CollectionUtils.isNotEmpty(groupsSlugs)) {
            serializedGroups = Joiner.on((String)";").join(groupsSlugs);
        }
        OrganizationMapping organization = (OrganizationMapping)this.activeObjects.get(OrganizationMapping.class, (Object)orgId);
        organization.setDefaultGroupsSlugs(serializedGroups);
        this.activeObjects.executeInTransaction(() -> {
            organization.save();
            return null;
        });
    }

    private static class OrganizationPopulatorVisitor
    implements CredentialVisitor<Unit> {
        private final OrganizationMapping organizationMapping;

        private OrganizationPopulatorVisitor(OrganizationMapping organizationMapping) {
            this.organizationMapping = organizationMapping;
            organizationMapping.setAdminPassword(null);
            organizationMapping.setAdminUsername(null);
            organizationMapping.setOauthKey(null);
            organizationMapping.setOauthSecret(null);
            organizationMapping.setAccessToken(null);
            organizationMapping.setPrincipalId(null);
        }

        public Unit visit(BasicAuthCredential credential) {
            this.organizationMapping.setAdminPassword(credential.getPassword());
            this.organizationMapping.setAdminUsername(credential.getUsername());
            return Unit.VALUE;
        }

        public Unit visit(PrincipalIDCredential credential) {
            this.organizationMapping.setPrincipalId(credential.getPrincipalId());
            return Unit.VALUE;
        }

        public Unit visit(TwoLeggedOAuthCredential credential) {
            this.organizationMapping.setOauthKey(credential.getKey());
            this.organizationMapping.setOauthSecret(credential.getSecret());
            return Unit.VALUE;
        }

        public Unit visit(ThreeLeggedOAuthCredential credential) {
            this.organizationMapping.setOauthKey(credential.getKey());
            this.organizationMapping.setOauthSecret(credential.getSecret());
            this.organizationMapping.setAccessToken(credential.getAccessToken());
            return Unit.VALUE;
        }

        public Unit visit(UnauthenticatedCredential credential) {
            return Unit.VALUE;
        }
    }

    private static class CredentialDBFieldVisitor
    implements CredentialVisitor<Map<String, Object>> {
        private final Organization organization;
        private final Map<String, Object> result;
        private final Encryptor encryptor;

        private CredentialDBFieldVisitor(Organization organization, Encryptor encryptor) {
            this.organization = organization;
            this.result = new HashMap<String, Object>();
            this.encryptor = encryptor;
        }

        public Map<String, Object> visit(BasicAuthCredential credential) {
            String encryptedPassword = this.encryptor.encrypt(credential.getPassword(), this.organization.getName(), this.organization.getHostUrl());
            this.result.put("ADMIN_PASSWORD", encryptedPassword);
            this.result.put("ADMIN_USERNAME", credential.getUsername());
            return this.result;
        }

        public Map<String, Object> visit(TwoLeggedOAuthCredential credential) {
            this.result.put("OAUTH_KEY", credential.getKey());
            this.result.put("OAUTH_SECRET", credential.getSecret());
            return this.result;
        }

        public Map<String, Object> visit(ThreeLeggedOAuthCredential credential) {
            this.result.put("OAUTH_KEY", credential.getKey());
            this.result.put("OAUTH_SECRET", credential.getSecret());
            this.result.put("ACCESS_TOKEN", credential.getAccessToken());
            return this.result;
        }

        public Map<String, Object> visit(PrincipalIDCredential credential) {
            this.result.put("PRINCIPAL_ID", credential.getPrincipalId());
            return this.result;
        }

        public Map<String, Object> visit(UnauthenticatedCredential credential) {
            this.result.put("ADMIN_PASSWORD", null);
            this.result.put("ADMIN_USERNAME", null);
            this.result.put("OAUTH_KEY", null);
            this.result.put("OAUTH_SECRET", null);
            this.result.put("ACCESS_TOKEN", null);
            this.result.put("PRINCIPAL_ID", null);
            return this.result;
        }
    }
}

