/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.ao.QueryHelper;
import com.atlassian.jira.plugins.dvcs.model.MessageState;
import com.atlassian.jira.plugins.dvcs.util.ao.QueryTemplate;
import com.atlassian.jira.plugins.dvcs.util.ao.query.QueryOrder;
import com.atlassian.jira.plugins.dvcs.util.ao.query.criteria.QueryCriterion;
import com.atlassian.jira.plugins.dvcs.util.ao.query.term.QueryTerm;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageQueueItemAoDaoImpl {
    private static final Logger log = LoggerFactory.getLogger(MessageQueueItemAoDaoImpl.class);
    @Resource
    @ComponentImport
    private ActiveObjects activeObjects;
    @Resource
    private QueryHelper queryHelper;

    public MessageQueueItemMapping create(Map<String, Object> parameters) {
        return (MessageQueueItemMapping)this.activeObjects.executeInTransaction(() -> (MessageQueueItemMapping)this.activeObjects.create(MessageQueueItemMapping.class, parameters));
    }

    public void save(MessageQueueItemMapping messageQueueItemMapping) {
        this.activeObjects.executeInTransaction(() -> {
            messageQueueItemMapping.save();
            return null;
        });
    }

    public void delete(MessageQueueItemMapping messageQueueItemMapping) {
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.delete(new RawEntity[]{messageQueueItemMapping});
            return null;
        });
    }

    public MessageQueueItemMapping[] getByMessageId(int id) {
        Query query = new QueryTemplate(this.queryHelper){

            protected void build() {
                this.alias(MessageQueueItemMapping.class, "queueItem");
                this.where(this.eq((QueryTerm)this.column(MessageQueueItemMapping.class, "MESSAGE_ID"), (QueryTerm)this.parameter("messageId")));
            }
        }.toQuery(Collections.singletonMap("messageId", id));
        return (MessageQueueItemMapping[])this.activeObjects.find(MessageQueueItemMapping.class, query);
    }

    public MessageQueueItemMapping getByQueueAndMessage(String queue, int messageId) {
        Query query = new QueryTemplate(this.queryHelper){

            protected void build() {
                this.alias(MessageQueueItemMapping.class, "messageQueue");
                this.where(this.and(new QueryCriterion[]{this.eq((QueryTerm)this.column(MessageQueueItemMapping.class, "QUEUE"), (QueryTerm)this.parameter("queue")), this.eq((QueryTerm)this.column(MessageQueueItemMapping.class, "MESSAGE_ID"), (QueryTerm)this.parameter("messageId"))}));
            }
        }.toQuery(MapBuilder.build((Object)"queue", (Object)queue, (Object)"messageId", (Object)messageId));
        MessageQueueItemMapping[] foundRecords = (MessageQueueItemMapping[])this.activeObjects.find(MessageQueueItemMapping.class, query);
        if (foundRecords.length > 1) {
            log.warn("found more than one match for " + messageId + " " + queue);
        }
        return foundRecords.length == 1 ? foundRecords[0] : null;
    }

    public MessageQueueItemMapping getNextItemForProcessing(String queue, String address) {
        MessageQueueItemMapping nextItemSoftSync = this.getNextItemForProcessingByPriority(10, queue, address);
        if (nextItemSoftSync != null) {
            return nextItemSoftSync;
        }
        return this.getNextItemForProcessingByPriority(0, queue, address);
    }

    private MessageQueueItemMapping getNextItemForProcessingByPriority(int priority, String queue, String address) {
        Query query = new QueryTemplate(this.queryHelper){

            protected void build() {
                this.alias(MessageQueueItemMapping.class, "queueItem");
                this.alias(MessageMapping.class, "message");
                this.join(MessageMapping.class, this.column(MessageQueueItemMapping.class, "MESSAGE_ID"), "ID");
                this.where(this.and(new QueryCriterion[]{this.eq((QueryTerm)this.column(MessageMapping.class, "ADDRESS"), (QueryTerm)this.parameter("address")), this.eq((QueryTerm)this.column(MessageMapping.class, "PRIORITY"), (QueryTerm)this.parameter("priority")), this.eq((QueryTerm)this.column(MessageQueueItemMapping.class, "QUEUE"), (QueryTerm)this.parameter("queue")), this.eq((QueryTerm)this.column(MessageQueueItemMapping.class, "STATE"), (QueryTerm)this.parameter("state"))}));
                this.order(new QueryOrder[]{this.orderBy(this.column(MessageMapping.class, MessageQueueItemAoDaoImpl.this.queryHelper.getSqlColumnName("ID")), true)});
            }
        }.toQuery(MapBuilder.build((Object)"address", (Object)address, (Object)"priority", (Object)priority, (Object)"queue", (Object)queue, (Object)"state", (Object)MessageState.PENDING));
        query.limit(1);
        MessageQueueItemMapping[] found = (MessageQueueItemMapping[])this.activeObjects.find(MessageQueueItemMapping.class, query);
        if (found.length > 1) {
            log.warn("found more than one match for " + priority + " " + queue + " " + address);
        }
        return found.length == 1 ? found[0] : null;
    }
}

