/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageQueueItemMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.MessageTagMapping;
import com.atlassian.jira.plugins.dvcs.ao.QueryHelper;
import com.atlassian.jira.plugins.dvcs.model.MessageState;
import com.atlassian.jira.plugins.dvcs.util.ao.QueryTemplate;
import com.atlassian.jira.plugins.dvcs.util.ao.query.criteria.QueryCriterion;
import com.atlassian.jira.plugins.dvcs.util.ao.query.term.QueryTerm;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Resource;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.stereotype.Component;

@Component
public class MessageAoDao {
    private static final MessageState[] MESSAGE_STATES = new MessageState[]{MessageState.PENDING, MessageState.RUNNING, MessageState.SLEEPING};
    @Resource
    @ComponentImport
    private ActiveObjects activeObjects;
    @Resource
    private QueryHelper queryHelper;

    public MessageMapping create(Map<String, Object> message, String[] tags) {
        return (MessageMapping)this.activeObjects.executeInTransaction(() -> {
            MessageMapping result = (MessageMapping)this.activeObjects.create(MessageMapping.class, message);
            for (String tag : tags) {
                this.activeObjects.create(MessageTagMapping.class, new DBParam[]{new DBParam("MESSAGE_ID", (Object)result.getID()), new DBParam("TAG", (Object)tag)});
            }
            return result;
        });
    }

    public MessageTagMapping createTag(int messageId, String tag) {
        return (MessageTagMapping)this.activeObjects.executeInTransaction(() -> (MessageTagMapping)this.activeObjects.create(MessageTagMapping.class, new DBParam[]{new DBParam("MESSAGE_ID", (Object)messageId), new DBParam("TAG", (Object)tag)}));
    }

    public void delete(MessageMapping message) {
        this.activeObjects.executeInTransaction(() -> {
            if (message.getTags() != null) {
                Arrays.stream(message.getTags()).forEach(xva$0 -> this.activeObjects.delete(new RawEntity[]{xva$0}));
            }
            this.activeObjects.delete(new RawEntity[]{message});
            return null;
        });
    }

    public MessageMapping getById(int id) {
        return (MessageMapping)this.activeObjects.get(MessageMapping.class, (Object)id);
    }

    public int getMessagesForConsumingCount(String tag) {
        Query query = new QueryTemplate(this.queryHelper){

            protected void build() {
                this.alias(MessageMapping.class, "messageMapping");
                this.alias(MessageTagMapping.class, "messageTag");
                this.alias(MessageQueueItemMapping.class, "messageQueueItem");
                this.join(MessageTagMapping.class, this.column(MessageMapping.class, "ID"), "MESSAGE_ID");
                this.join(MessageQueueItemMapping.class, this.column(MessageMapping.class, "ID"), "MESSAGE_ID");
                this.where(this.and(new QueryCriterion[]{this.eq((QueryTerm)this.column(MessageTagMapping.class, "TAG"), (QueryTerm)this.parameter("tag")), this.in(this.column(MessageQueueItemMapping.class, "STATE"), this.parameter("state"))}));
            }
        }.toQuery(MapBuilder.build((Object)"tag", (Object)tag, (Object)"state", (Object)MESSAGE_STATES));
        return this.activeObjects.count(MessageMapping.class, query);
    }
}

