/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.util.ActiveObjectsUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;

public class GlobalFilterQueryWhereClauseBuilder {
    private final GlobalFilter gf;

    public GlobalFilterQueryWhereClauseBuilder(GlobalFilter gf) {
        this.gf = gf;
    }

    public SqlAndParams build() {
        ArrayList params = Lists.newArrayList();
        StringBuilder whereClauseProjectsSb = new StringBuilder();
        StringBuilder whereClauseIssueKyesSb = new StringBuilder();
        StringBuilder whereClauseUsersSb = new StringBuilder();
        if (this.gf != null) {
            if (this.gf.getInProjects() != null && this.gf.getInProjects().iterator().hasNext()) {
                whereClauseProjectsSb.append(this.renderSqlIn("ISSUE.PROJECT_KEY", this.gf.getInProjects())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getInProjects()));
            }
            if (this.gf.getNotInProjects() != null && this.gf.getNotInProjects().iterator().hasNext()) {
                if (whereClauseProjectsSb.length() != 0) {
                    whereClauseProjectsSb.append(" AND ");
                }
                whereClauseProjectsSb.append(this.renderSqlNotIn("ISSUE.PROJECT_KEY", this.gf.getNotInProjects())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getNotInProjects()));
            }
            if (this.gf.getInIssues() != null && this.gf.getInIssues().iterator().hasNext()) {
                whereClauseIssueKyesSb.append(this.renderSqlIn("ISSUE.ISSUE_KEY", this.gf.getInIssues())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getInIssues()));
            }
            if (this.gf.getNotInIssues() != null && this.gf.getNotInIssues().iterator().hasNext()) {
                if (whereClauseIssueKyesSb.length() != 0) {
                    whereClauseIssueKyesSb.append(" AND ");
                }
                whereClauseIssueKyesSb.append(this.renderSqlNotIn("ISSUE.ISSUE_KEY", this.gf.getNotInIssues())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getNotInIssues()));
            }
            if (this.gf.getInUsers() != null && this.gf.getInUsers().iterator().hasNext()) {
                whereClauseUsersSb.append(this.renderSqlIn("CHANGESET.AUTHOR", this.gf.getInUsers())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getInUsers()));
            }
            if (this.gf.getNotInUsers() != null && this.gf.getNotInUsers().iterator().hasNext()) {
                whereClauseUsersSb.append(this.renderSqlNotIn("CHANGESET.AUTHOR", this.gf.getNotInUsers())).append(" ");
                params.addAll(Lists.newArrayList((Iterable)this.gf.getNotInUsers()));
            }
        }
        StringBuilder whereClauseSb = new StringBuilder();
        if (whereClauseProjectsSb.length() != 0) {
            whereClauseSb.append("(").append(whereClauseProjectsSb.toString()).append(")");
        }
        if (whereClauseIssueKyesSb.length() != 0) {
            if (whereClauseSb.length() != 0) {
                whereClauseSb.append(" AND ");
            }
            whereClauseSb.append("(").append(whereClauseIssueKyesSb.toString()).append(")");
        }
        if (whereClauseUsersSb.length() != 0) {
            if (whereClauseSb.length() != 0) {
                whereClauseSb.append(" AND ");
            }
            whereClauseSb.append("(").append(whereClauseUsersSb.toString()).append(")");
        }
        if (whereClauseSb.length() == 0) {
            whereClauseSb.append(" true ");
        }
        return new SqlAndParams(whereClauseSb.toString(), params.toArray());
    }

    private String renderSqlNotIn(String column, Iterable<String> values) {
        return ActiveObjectsUtils.renderListOperator((String)column, (String)"NOT IN", (String)"AND", values);
    }

    private String renderSqlIn(String column, Iterable<String> values) {
        return ActiveObjectsUtils.renderListOperator((String)column, (String)"IN", (String)"OR", values);
    }

    static class SqlAndParams {
        private String sql;
        private Object[] params;

        private SqlAndParams(String sql, Object[] params) {
            this.sql = sql;
            this.params = params;
        }

        public String getSql() {
            return this.sql;
        }

        public Object[] getParams() {
            return this.params;
        }
    }
}

