/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.GitHubEventMapping;
import com.atlassian.jira.plugins.dvcs.ao.QueryHelper;
import com.atlassian.jira.plugins.dvcs.dao.GitHubEventDAO;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.annotation.Resource;
import net.java.ao.Query;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GitHubEventDAOImpl
implements GitHubEventDAO {
    private static final Logger log = LoggerFactory.getLogger(GitHubEventDAOImpl.class);
    @Resource
    @ComponentImport
    private ActiveObjects activeObjects;
    @Resource
    private QueryHelper queryHelper;

    @Override
    public GitHubEventMapping create(Map<String, Object> gitHubEvent) {
        String gitHubId;
        GitHubEventMapping createdMapping = (GitHubEventMapping)this.activeObjects.executeInTransaction(() -> (GitHubEventMapping)this.activeObjects.create(GitHubEventMapping.class, gitHubEvent));
        int repositoryId = createdMapping.getRepository().getID();
        GitHubEventMapping[] retrievedMappings = this.findAllById(repositoryId, gitHubId = createdMapping.getGitHubId());
        if (retrievedMappings.length > 1) {
            String stack = ExceptionUtils.getStackTrace((Throwable)new Throwable());
            String warningMessage = "Just created a GitHubEventMapping for repository {} and gitHubId {} and there now more than one in the database. This is the calling stack:\n";
            log.warn("Just created a GitHubEventMapping for repository {} and gitHubId {} and there now more than one in the database. This is the calling stack:\n", new Object[]{repositoryId, gitHubId, stack});
        }
        return createdMapping;
    }

    @Override
    public void markAsSavePoint(GitHubEventMapping gitHubEvent) {
        this.activeObjects.executeInTransaction(() -> {
            gitHubEvent.setSavePoint(true);
            gitHubEvent.save();
            return null;
        });
    }

    @Override
    public void removeAll(Repository repository) {
        this.activeObjects.deleteWithSQL(GitHubEventMapping.class, "REPOSITORY_ID = ? ", new Object[]{repository.getId()});
    }

    @Override
    public GitHubEventMapping getByGitHubId(Repository repository, String gitHubId) {
        GitHubEventMapping[] githubEvents = this.findAllById(repository.getId(), gitHubId);
        if (githubEvents.length > 1) {
            Object[] warnParams = new Object[]{gitHubId, repository.getId(), githubEvents.length};
            log.warn("Search for event {} in repository {} found this many {}, returning the one marked as a save point, if none are save points then the first", warnParams);
            GitHubEventMapping eventToUse = githubEvents[0];
            for (GitHubEventMapping retrievedMapping : githubEvents) {
                if (!retrievedMapping.isSavePoint()) continue;
                eventToUse = retrievedMapping;
            }
            Object[] infoParams = new Object[]{gitHubId, repository.getId(), eventToUse.getID()};
            log.info("When multiple git hub events were found for event {} in repository {} we chose the one with this id {}", infoParams);
            return eventToUse;
        }
        return githubEvents.length == 1 ? githubEvents[0] : null;
    }

    private GitHubEventMapping[] findAllById(int repositoryId, String gitHubId) {
        Query query = Query.select().where("REPOSITORY_ID = ? AND GIT_HUB_ID = ? ", new Object[]{repositoryId, gitHubId}).order("ID");
        return (GitHubEventMapping[])this.activeObjects.find(GitHubEventMapping.class, query);
    }

    @Override
    public GitHubEventMapping getLastSavePoint(Repository repository) {
        Query query = Query.select();
        query.where("REPOSITORY_ID = ? AND SAVE_POINT = ? ", new Object[]{repository.getId(), true});
        query.setOrderClause(this.queryHelper.getOrder(new QueryHelper.OrderClause[]{new QueryHelper.OrderClause("CREATED_AT", QueryHelper.OrderClause.Order.DESC), new QueryHelper.OrderClause("ID", QueryHelper.OrderClause.Order.DESC)}));
        query.setLimit(1);
        GitHubEventMapping[] founded = (GitHubEventMapping[])this.activeObjects.find(GitHubEventMapping.class, query);
        return founded.length == 1 ? founded[0] : null;
    }
}

