/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.IssueToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.ao.QueryHelper;
import com.atlassian.jira.plugins.dvcs.dao.IssueToMappingFunction;
import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.dao.impl.GlobalFilterQueryWhereClauseBuilder;
import com.atlassian.jira.plugins.dvcs.dao.impl.MapRemovingNullCharacterFromStringValues;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.ChangesetTransformer;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetails;
import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.util.CustomStringUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Unit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.Table;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangesetDaoImpl {
    private static final Logger log = LoggerFactory.getLogger(ChangesetDaoImpl.class);
    private final ActiveObjects activeObjects;
    private final ChangesetTransformer transformer;
    private final QueryHelper queryHelper;

    public static String parseProjectKey(String issueKey) {
        return issueKey.substring(0, issueKey.indexOf("-"));
    }

    @Autowired
    public ChangesetDaoImpl(@ComponentImport ActiveObjects activeObjects, QueryHelper queryHelper) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.queryHelper = (QueryHelper)Preconditions.checkNotNull((Object)queryHelper);
        this.transformer = new ChangesetTransformer(this);
    }

    private Changeset transform(ChangesetMapping changesetMapping, int defaultRepositoryId) {
        return this.transform(changesetMapping, defaultRepositoryId, null);
    }

    private Changeset transform(ChangesetMapping changesetMapping, int defaultRepositoryId, String dvcsType) {
        return this.transformer.transform(changesetMapping, defaultRepositoryId, dvcsType);
    }

    private List<Changeset> transform(List<ChangesetMapping> changesetMappings) {
        return this.transform(changesetMappings, 0, null);
    }

    private List<Changeset> transform(List<ChangesetMapping> changesetMappings, String dvcsType) {
        return this.transform(changesetMappings, 0, dvcsType);
    }

    private List<Changeset> transform(List<ChangesetMapping> changesetMappings, int defaultRepositoryId, String dvcsType) {
        return changesetMappings.stream().map(cset -> this.transform((ChangesetMapping)cset, defaultRepositoryId, dvcsType)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void removeAllInRepository(int repositoryId) {
        long startTime = System.currentTimeMillis();
        this.activeObjects.executeInTransaction(() -> {
            log.debug("deleting repo - changesets associations from RepoToChangeset with id = [ {} ]", (Object)repositoryId);
            this.activeObjects.deleteWithSQL(RepositoryToChangesetMapping.class, "REPOSITORY_ID = ?", new Object[]{repositoryId});
            log.debug("deleting orphaned issue-changeset associations");
            this.activeObjects.deleteWithSQL(IssueToChangesetMapping.class, String.format("not exists (select 1 from %s where %s.%s = %s )", this.queryHelper.getSqlTableName("AO_E8B6CC_REPO_TO_CHANGESET"), this.queryHelper.getSqlTableName("AO_E8B6CC_ISSUE_TO_CHANGESET"), this.queryHelper.getSqlColumnName("CHANGESET_ID"), this.queryHelper.getSqlColumnName("CHANGESET_ID")), new Object[0]);
            log.debug("deleting orphaned changesets");
            this.activeObjects.deleteWithSQL(ChangesetMapping.class, String.format("not exists (select 1 from %s where %s.%s = %s )", this.queryHelper.getSqlTableName("AO_E8B6CC_REPO_TO_CHANGESET"), this.queryHelper.getSqlTableName("AO_E8B6CC_CHANGESET_MAPPING"), this.queryHelper.getSqlColumnName("ID"), this.queryHelper.getSqlColumnName("CHANGESET_ID")), new Object[0]);
            return Unit.Unit();
        });
        log.debug("Changesets in repository {} were deleted in {} ms", (Object)repositoryId, (Object)(System.currentTimeMillis() - startTime));
    }

    public Changeset create(Changeset changeset, Set<String> extractedIssues) {
        this.createOrAssociate(changeset, extractedIssues);
        return changeset;
    }

    public boolean createOrAssociate(Changeset changeset, Set<String> extractedIssues) {
        MutableBoolean wasCreated = new MutableBoolean(false);
        ChangesetMapping changesetMapping = (ChangesetMapping)this.activeObjects.executeInTransaction(() -> {
            ChangesetMapping chm = this.getChangesetMapping(changeset);
            if (chm == null) {
                chm = (ChangesetMapping)this.activeObjects.create(ChangesetMapping.class, new DBParam[0]);
                this.fillProperties(changeset, chm);
                chm.save();
                wasCreated.setValue(true);
            }
            this.associateRepositoryToChangeset(chm, changeset.getRepositoryId());
            if (extractedIssues != null) {
                this.associateIssuesToChangeset(chm, extractedIssues);
            }
            return chm;
        });
        changeset.setId(changesetMapping.getID());
        return wasCreated.booleanValue();
    }

    public Changeset update(Changeset changeset) {
        this.activeObjects.executeInTransaction(() -> {
            ChangesetMapping chm = this.getChangesetMapping(changeset);
            if (chm != null) {
                this.fillProperties(changeset, chm);
                chm.save();
            } else {
                log.warn("Changeset with node {} does not exist.", (Object)changeset.getNode());
            }
            return chm;
        });
        return changeset;
    }

    public Changeset migrateFilesData(Changeset changeset, String dvcsType) {
        this.activeObjects.executeInTransaction(() -> {
            ChangesetMapping chm = this.getChangesetMapping(changeset);
            if (chm != null) {
                this.transformer.migrateChangesetFileData(chm, dvcsType, changeset);
            } else {
                log.warn("Changeset with node {} does not exist.", (Object)changeset.getNode());
            }
            return chm;
        });
        return changeset;
    }

    private ChangesetMapping getChangesetMapping(Changeset changeset) {
        String hasRawNode = "( RAW_NODE is not null AND RAW_NODE != '') ";
        String matchRawNode = "RAW_NODE = ? ";
        String matchNode = " ( NODE >= ? AND NODE < ? )";
        String shortNode = changeset.getNode().substring(0, 12);
        String shortNodeNext = changeset.getNode().substring(0, 12) + 'g';
        ChangesetMapping[] mappings = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, "(" + hasRawNode + " AND " + matchRawNode + " ) OR ( NOT " + hasRawNode + " AND " + matchNode + " ) ", new Object[]{changeset.getRawNode(), shortNode, shortNodeNext});
        if (mappings.length > 1) {
            log.warn("Multiple changesets with same Node. Same changesets count: {}, Node: {}, Repository: {}", new Object[]{mappings.length, changeset.getNode(), changeset.getRepositoryId()});
        }
        return Arrays.stream(mappings).findFirst().orElse(null);
    }

    private void fillProperties(Changeset changeset, ChangesetMapping chm) {
        chm.setNode(changeset.getNode());
        chm.setRawAuthor(CustomStringUtils.stripToLimit((String)changeset.getRawAuthor(), (int)255));
        chm.setAuthor(changeset.getAuthor());
        chm.setDate(changeset.getDate());
        chm.setRawNode(changeset.getRawNode());
        chm.setBranch(CustomStringUtils.stripToLimit((String)changeset.getBranch(), (int)255));
        chm.setMessage(changeset.getMessage());
        chm.setAuthorEmail(CustomStringUtils.stripToLimit((String)changeset.getAuthorEmail(), (int)255));
        chm.setSmartcommitAvailable(changeset.isSmartcommitAvaliable());
        JSONArray parentsJson = new JSONArray();
        changeset.getParents().forEach(arg_0 -> ((JSONArray)parentsJson).put(arg_0));
        String parentsData = parentsJson.toString();
        if (parentsData.length() > 255) {
            parentsData = "<TOO_MANY_PARENTS>";
        }
        chm.setParentsData(parentsData);
        chm.setFilesData(null);
        chm.setFileCount(changeset.getAllFileCount());
        chm.setFileDetailsJson(ChangesetFileDetails.toJSON(changeset.getFileDetails()));
        chm.setVersion(3);
        chm.save();
    }

    private void associateIssuesToChangeset(ChangesetMapping changesetMapping, Set<String> extractedIssues) {
        this.activeObjects.deleteWithSQL(IssueToChangesetMapping.class, "CHANGESET_ID = ? ", new Object[]{changesetMapping});
        for (String extractedIssue : extractedIssues) {
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("ISSUE_KEY", extractedIssue);
            map.put("PROJECT_KEY", ChangesetDaoImpl.parseProjectKey(extractedIssue));
            map.put("CHANGESET_ID", changesetMapping.getID());
            this.activeObjects.create(IssueToChangesetMapping.class, (Map)map);
        }
    }

    private void associateRepositoryToChangeset(ChangesetMapping changesetMapping, int repositoryId) {
        Object[] mappings = (RepositoryToChangesetMapping[])this.activeObjects.find(RepositoryToChangesetMapping.class, "REPOSITORY_ID = ? and CHANGESET_ID = ? ", new Object[]{repositoryId, changesetMapping});
        if (ArrayUtils.isEmpty((Object[])mappings)) {
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("REPOSITORY_ID", repositoryId);
            map.put("CHANGESET_ID", changesetMapping);
            this.activeObjects.create(RepositoryToChangesetMapping.class, (Map)map);
        }
    }

    public Changeset getByNode(int repositoryId, String changesetNode) {
        ChangesetMapping changesetMapping = (ChangesetMapping)this.activeObjects.executeInTransaction(() -> {
            Query query = Query.select().from(ChangesetMapping.class).alias(ChangesetMapping.class, "chm").alias(RepositoryToChangesetMapping.class, "rtchm").join(RepositoryToChangesetMapping.class, "chm.ID = rtchm.CHANGESET_ID").where("chm.NODE = ? AND rtchm.REPOSITORY_ID = ? ", new Object[]{changesetNode, repositoryId});
            ChangesetMapping[] mappings = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, query);
            return mappings.length != 0 ? mappings[0] : null;
        });
        return this.transform(changesetMapping, repositoryId);
    }

    public List<Changeset> getByIssueKey(Iterable<String> issueKeys, boolean newestFirst) {
        return this.getByIssueKey(issueKeys, null, newestFirst);
    }

    public List<Changeset> getByIssueKey(Iterable<String> issueKeys, @Nullable String dvcsType, boolean newestFirst) {
        List<ChangesetMapping> changesetMappings = this.getChangesetMappingsByIssueKey(issueKeys, newestFirst);
        return this.transform(changesetMappings, dvcsType);
    }

    public List<Changeset> getByRepository(int repositoryId) {
        List changesetMappings = (List)this.activeObjects.executeInTransaction(() -> {
            ChangesetMapping[] mappings = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, Query.select().alias(ChangesetMapping.class, "CHANGESET").alias(RepositoryToChangesetMapping.class, "REPO").join(RepositoryToChangesetMapping.class, "CHANGESET.ID = REPO.CHANGESET_ID").where("REPO.ID = ?", new Object[]{repositoryId}));
            return Arrays.asList(mappings);
        });
        return this.transform(changesetMappings);
    }

    private List<ChangesetMapping> getChangesetMappingsByIssueKey(Iterable<String> issueKeys, boolean newestFirst) {
        GlobalFilter gf = new GlobalFilter();
        gf.setInIssues(issueKeys);
        GlobalFilterQueryWhereClauseBuilder.SqlAndParams baseWhereClause = new GlobalFilterQueryWhereClauseBuilder(gf).build();
        return (List)this.activeObjects.executeInTransaction(() -> {
            ChangesetMapping[] mappings = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, Query.select().alias(ChangesetMapping.class, "CHANGESET").alias(IssueToChangesetMapping.class, "ISSUE").join(IssueToChangesetMapping.class, "CHANGESET.ID = ISSUE.CHANGESET_ID").where(baseWhereClause.getSql(), baseWhereClause.getParams()).order("DATE" + (newestFirst ? " DESC" : " ASC")).limit(DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY));
            return Arrays.asList(mappings);
        });
    }

    public List<Changeset> getLatestChangesets(int maxResults, GlobalFilter gf) {
        if (maxResults <= 0) {
            return Collections.emptyList();
        }
        List changesetMappings = (List)this.activeObjects.executeInTransaction(() -> {
            GlobalFilterQueryWhereClauseBuilder.SqlAndParams baseWhereClause = new GlobalFilterQueryWhereClauseBuilder(gf).build();
            Query query = Query.select().alias(ChangesetMapping.class, "CHANGESET").alias(IssueToChangesetMapping.class, "ISSUE").alias(RepositoryToChangesetMapping.class, "REPO").join(IssueToChangesetMapping.class, "CHANGESET.ID = ISSUE.CHANGESET_ID").join(RepositoryToChangesetMapping.class, "CHANGESET.ID = REPO.CHANGESET_ID").where(baseWhereClause.getSql(), baseWhereClause.getParams()).limit(maxResults).order("DATE DESC");
            ChangesetMapping[] mappings = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, query);
            return Arrays.asList(mappings);
        });
        return this.transform(changesetMappings);
    }

    public int getNumberOfIssueKeysToChangeset() {
        Query query = Query.select((String)"ISSUE_KEY").from(IssueToChangesetMapping.class);
        return this.activeObjects.count(IssueToChangesetMapping.class, query);
    }

    public boolean forEachIssueKeyMapping(Organization organization, Repository repository, int pageSize, IssueToMappingFunction function) {
        boolean result;
        IssueToChangesetMapping[] mappings;
        int currentPage = 0;
        int repositoryId = repository.getId();
        do {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Query issueQuery = Query.select().from(IssueToChangesetMapping.class).alias(IssueToChangesetMapping.class, "ic").alias(ChangesetMapping.class, "cm").join(ChangesetMapping.class, "ic.CHANGESET_ID = cm.ID").alias(RepositoryToChangesetMapping.class, "rtoc").join(RepositoryToChangesetMapping.class, "cm.ID = rtoc.CHANGESET_ID").alias(RepositoryMapping.class, "rm").join(RepositoryMapping.class, "rm.ID = rtoc.REPOSITORY_ID").where("rm.ID = ?", new Object[]{repositoryId}).limit(pageSize).offset(currentPage * pageSize);
            mappings = (IssueToChangesetMapping[])this.activeObjects.find(IssueToChangesetMapping.class, issueQuery);
            ++currentPage;
            ImmutableSet.Builder setBuilder = ImmutableSet.builder();
            for (IssueToChangesetMapping mapping : mappings) {
                setBuilder.add((Object)mapping.getIssueKey());
            }
            ImmutableSet issueKeys = setBuilder.build();
            result = function.execute(organization.getDvcsType(), repositoryId, (Set)issueKeys);
            log.info("processing page {} with this many elements {} took {} and had the result {}", new Object[]{currentPage, issueKeys.size(), stopWatch, result});
        } while (mappings.length > 0 && result);
        return result;
    }

    public Set<String> findReferencedProjects(int repositoryId) {
        Query query = Query.select((String)"PROJECT_KEY").distinct().alias(ProjectKey.class, "pk").alias(ChangesetMapping.class, "chm").alias(RepositoryToChangesetMapping.class, "rtchm").join(ChangesetMapping.class, "chm.ID = pk.CHANGESET_ID").join(RepositoryToChangesetMapping.class, "chm.ID = rtchm.CHANGESET_ID").where("rtchm.REPOSITORY_ID = ?", new Object[]{repositoryId}).order("PROJECT_KEY");
        return Stream.of(this.activeObjects.find(ProjectKey.class, query)).map(ProjectKey::getProjectKey).collect(Collectors.toSet());
    }

    public Set<String> findEmails(int repositoryId, String author) {
        Query query = Query.select((String)"AUTHOR_EMAIL").distinct().from(ChangesetMapping.class).alias(ChangesetMapping.class, "chm").alias(RepositoryToChangesetMapping.class, "rtchm").join(RepositoryToChangesetMapping.class, "chm.ID = rtchm.CHANGESET_ID").where("rtchm.REPOSITORY_ID = ? and chm.AUTHOR = ? ", new Object[]{repositoryId, author}).limit(1);
        return Stream.of(this.activeObjects.find(AuthorEmail.class, query)).map(AuthorEmail::getAuthorEmail).collect(Collectors.toSet());
    }

    public int getChangesetCount(int repositoryId) {
        return (Integer)this.activeObjects.executeInTransaction(() -> {
            Query query = Query.select().where("REPOSITORY_ID = ?", new Object[]{repositoryId});
            return this.activeObjects.count(RepositoryToChangesetMapping.class, query);
        });
    }

    @Table(value="IssueToChangeset")
    static interface ProjectKey
    extends RawEntity<String> {
        @PrimaryKey(value="PROJECT_KEY")
        public String getProjectKey();

        public void setProjectKey();
    }

    @Table(value="ChangesetMapping")
    static interface AuthorEmail
    extends RawEntity<String> {
        @PrimaryKey(value="AUTHOR_EMAIL")
        public String getAuthorEmail();

        public void setAuthorEmail();
    }
}

