/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationAOFacade;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.OrganizationQueryDslFacade;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="organizationDao")
public class CachingOrganizationDaoImpl
implements OrganizationDao {
    private static final Logger log = LoggerFactory.getLogger(CachingOrganizationDaoImpl.class);
    private static final CacheSettings CACHE_SETTINGS = new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    @ClusterSafe
    private final CachedReference<List<Organization>> organizationsCache;
    private final OrganizationAOFacade organizationAOFacade;
    private final OrganizationQueryDslFacade organizationQueryDslFacade;
    private final EventPublisher eventPublisher;

    @Inject
    public CachingOrganizationDaoImpl(@ComponentImport @Nonnull CacheManager cacheManager, @ComponentImport @Nonnull EventPublisher eventPublisher, @Nonnull OrganizationAOFacade organizationAOFacade, @Nonnull OrganizationQueryDslFacade organizationQueryDslFacade) {
        Preconditions.checkNotNull((Object)cacheManager);
        this.organizationAOFacade = (OrganizationAOFacade)Preconditions.checkNotNull((Object)organizationAOFacade);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.organizationQueryDslFacade = (OrganizationQueryDslFacade)Preconditions.checkNotNull((Object)organizationQueryDslFacade);
        this.organizationsCache = cacheManager.getCachedReference(this.getClass().getName() + ".organizationsCache", organizationAOFacade::fetch, CACHE_SETTINGS);
    }

    public List<Organization> getAll() {
        return this.cloneOrgs(this.getAllCachedOrgs());
    }

    public int getAllCount() {
        return this.getAllCachedOrgs().size();
    }

    public List<Organization> getAllByType(String dvcsType) {
        List<Organization> orgs = this.getAllCachedOrgs();
        Iterable orgsByType = Iterables.filter(orgs, org -> dvcsType.equals(org.getDvcsType()));
        return this.cloneOrgs(orgsByType);
    }

    public List<Integer> getAllOrganizationsWithEnabledRepos() {
        return this.organizationQueryDslFacade.getAllOrganizationsWithEnabledRepos();
    }

    public void setLastPolled(Organization org, long timestamp) {
        this.organizationQueryDslFacade.setLastPolled(org.getId(), timestamp);
    }

    public Organization get(int organizationId) {
        return this.findOrganization((Predicate<Organization>)((Predicate)org -> org.getId() == organizationId));
    }

    public Organization getByPrincipalId(String principalId) {
        return this.findOrganization((Predicate<Organization>)((Predicate)org -> {
            Optional credential = (Optional)org.getCredential().accept(PrincipalIDCredential.visitor());
            return credential.isPresent() && ((PrincipalIDCredential)credential.get()).getPrincipalId().equals(principalId);
        }));
    }

    public Organization getByHostAndName(String hostUrl, String name) {
        Preconditions.checkNotNull((Object)hostUrl);
        Preconditions.checkNotNull((Object)name);
        return this.findOrganization((Predicate<Organization>)((Predicate)org -> hostUrl.equals(org.getHostUrl()) && name.equalsIgnoreCase(org.getName())));
    }

    public List<Organization> getAllByIds(Collection<Integer> ids) {
        Preconditions.checkNotNull(ids);
        List<Organization> orgs = this.getAllCachedOrgs();
        Iterable orgsByIds = Iterables.filter(orgs, org -> ids.contains(org.getId()));
        return this.cloneOrgs(orgsByIds);
    }

    public boolean existsOrganizationWithType(String ... types) {
        if (types == null || ArrayUtils.isEmpty((Object[])types)) {
            return false;
        }
        List<String> typeList = Arrays.asList(types);
        Organization org = this.findOrganization((Predicate<Organization>)((Predicate)o -> typeList.contains(o.getDvcsType())));
        return org != null;
    }

    public Collection<String> getAllProjectKeysFromChangesetsInOrganization(int orgId) {
        return this.organizationQueryDslFacade.getAllProjectKeysFromChangesetsInOrganization(orgId);
    }

    public Iterable<String> getCurrentlyLinkedProjects(int orgId) {
        return this.organizationQueryDslFacade.getCurrentlyLinkedProjects(orgId);
    }

    public long linkProject(int orgId, String projectKey) {
        return this.organizationQueryDslFacade.linkProject(orgId, projectKey);
    }

    public void updateLinkedProjects(int orgId, Iterable<String> newProjectKeys) {
        this.organizationQueryDslFacade.updateLinkedProjects(orgId, newProjectKeys);
    }

    public void remove(int organizationId) {
        this.organizationQueryDslFacade.remove(organizationId);
        this.clearCache();
    }

    public Organization save(Organization organization) {
        Organization org = this.organizationAOFacade.save(organization);
        if (org != null) {
            this.clearCache();
        }
        return org;
    }

    public void setDefaultGroupsSlugs(int orgId, Collection<String> groupsSlugs) {
        this.organizationAOFacade.updateDefaultGroupsSlugs(orgId, groupsSlugs);
        this.clearCache();
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onImportCompleted(ImportCompletedEvent event) {
        log.warn("onImportCompleted - clearing cache !!");
        this.clearCache();
    }

    private void clearCache() {
        this.organizationsCache.reset();
    }

    private List<Organization> getAllCachedOrgs() {
        return (List)this.organizationsCache.get();
    }

    private Organization findOrganization(Predicate<Organization> predicate) {
        List<Organization> orgs = this.getAllCachedOrgs();
        Organization matchedOrg = (Organization)Iterables.find(orgs, predicate, null);
        return matchedOrg != null ? new Organization(matchedOrg) : null;
    }

    private List<Organization> cloneOrgs(@Nonnull Iterable<Organization> orgs) {
        return Lists.newArrayList((Iterable)Iterables.transform(orgs, Organization::new));
    }
}

