/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.BranchHeadMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.BranchMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.IssueToBranchMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.dao.impl.DAOConstants;
import com.atlassian.jira.plugins.dvcs.dao.impl.MapRemovingNullCharacterFromStringValues;
import com.atlassian.jira.plugins.dvcs.model.Branch;
import com.atlassian.jira.plugins.dvcs.model.BranchHead;
import com.atlassian.jira.plugins.dvcs.util.ActiveObjectsUtils;
import com.atlassian.jira.plugins.dvcs.util.CustomStringUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Iterables;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BranchDaoImpl {
    private static final Logger log = LoggerFactory.getLogger(BranchDaoImpl.class);
    private final ActiveObjects activeObjects;

    @Inject
    public BranchDaoImpl(@ComponentImport ActiveObjects activeObjects) {
        this.activeObjects = Objects.requireNonNull(activeObjects);
    }

    private static List<Branch> asBranches(BranchMapping[] branches, ToIntFunction<BranchMapping> repoIdFunction) {
        return Arrays.stream(branches).map(branch -> new Branch(branch.getID(), branch.getName(), repoIdFunction.applyAsInt((BranchMapping)branch))).collect(Collectors.toList());
    }

    private static List<Branch> asBranches(BranchMapping[] branches) {
        return BranchDaoImpl.asBranches(branches, branch -> branch.getRepository().getID());
    }

    private static List<BranchHead> asBranchHeads(BranchHeadMapping[] branchHeadMappings) {
        return Arrays.stream(branchHeadMappings).map(row -> new BranchHead(row.getBranchName(), row.getHead())).collect(Collectors.toList());
    }

    private static Object[] join(Object[] array, Iterable<?> iterable) {
        return ObjectArrays.concat((Object[])array, (Object[])Iterables.toArray(iterable, Object.class), Object.class);
    }

    public List<BranchHead> getBranchHeads(int repositoryId) {
        Query selector = Query.select().where("REPOSITORY_ID = ?", new Object[]{repositoryId});
        return BranchDaoImpl.asBranchHeads((BranchHeadMapping[])this.activeObjects.find(BranchHeadMapping.class, selector));
    }

    public List<Branch> getBranches(int repositoryId) {
        Query selector = Query.select().where("REPOSITORY_ID = ?", new Object[]{repositoryId});
        return BranchDaoImpl.asBranches((BranchMapping[])this.activeObjects.find(BranchMapping.class, selector), branch -> repositoryId);
    }

    public void createBranch(int repositoryId, Branch branch, Iterable<String> issueKeys) {
        this.activeObjects.executeInTransaction(() -> {
            log.debug("adding branch {} for repository with id = [{}]", (Object)branch, (Object)repositoryId);
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("REPOSITORY_ID", repositoryId);
            map.put("NAME", CustomStringUtils.stripToLimit((String)branch.getName(), (int)255));
            BranchMapping branchMapping = (BranchMapping)this.activeObjects.create(BranchMapping.class, (Map)map);
            this.associateBranchWithIssues(branchMapping, issueKeys);
            return null;
        });
    }

    public void createBranchHead(int repositoryId, BranchHead branchHead) {
        this.activeObjects.executeInTransaction(() -> {
            log.debug("adding branch head {} for repository with id = [{}]", (Object)branchHead, (Object)repositoryId);
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("REPOSITORY_ID", repositoryId);
            map.put("BRANCH_NAME", CustomStringUtils.stripToLimit((String)branchHead.getName(), (int)255));
            map.put("HEAD", branchHead.getHead());
            this.activeObjects.create(BranchHeadMapping.class, (Map)map);
            return null;
        });
    }

    public void removeBranchHead(int repositoryId, BranchHead branch) {
        this.activeObjects.executeInTransaction(() -> {
            log.debug("deleting branch head {} for repository with id = [{}]", (Object)branch, (Object)repositoryId);
            this.activeObjects.deleteWithSQL(BranchHeadMapping.class, "REPOSITORY_ID = ? AND BRANCH_NAME = ? AND HEAD = ?", new Object[]{repositoryId, branch.getName(), branch.getHead()});
            return null;
        });
    }

    public void removeAllBranchHeadsInRepository(int repositoryId) {
        log.debug("deleting branch heads for repository with id = [{}]", (Object)repositoryId);
        this.activeObjects.executeInTransaction(() -> {
            this.activeObjects.deleteWithSQL(BranchHeadMapping.class, "REPOSITORY_ID = ?", new Object[]{repositoryId});
            return null;
        });
    }

    public List<Branch> getBranchesForIssue(Iterable<String> issueKeys) {
        String baseWhereClause = ActiveObjectsUtils.renderListOperator((String)"mapping.ISSUE_KEY", (String)"IN", (String)"OR", issueKeys);
        Object[] params = BranchDaoImpl.join(new Object[]{Boolean.FALSE, Boolean.TRUE}, issueKeys);
        return BranchDaoImpl.asBranches((BranchMapping[])this.activeObjects.executeInTransaction(() -> (BranchMapping[])this.activeObjects.find(BranchMapping.class, Query.select().alias(IssueToBranchMapping.class, "mapping").alias(BranchMapping.class, "branch").alias(RepositoryMapping.class, "repo").join(IssueToBranchMapping.class, "mapping.BRANCH_ID = branch.ID").join(RepositoryMapping.class, "branch.REPOSITORY_ID = repo.ID").where("repo.DELETED = ? AND repo.LINKED = ? AND " + baseWhereClause, params).order("NAME").limit(DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY))));
    }

    public List<Branch> getBranchesForIssue(Iterable<String> issueKeys, String dvcsType) {
        String baseWhereClause = ActiveObjectsUtils.renderListOperator((String)"mapping.ISSUE_KEY", (String)"IN", (String)"OR", issueKeys);
        Object[] params = BranchDaoImpl.join(new Object[]{dvcsType, Boolean.FALSE, Boolean.TRUE}, issueKeys);
        return BranchDaoImpl.asBranches((BranchMapping[])this.activeObjects.executeInTransaction(() -> (BranchMapping[])this.activeObjects.find(BranchMapping.class, Query.select().alias(IssueToBranchMapping.class, "mapping").alias(BranchMapping.class, "branch").alias(RepositoryMapping.class, "repo").alias(OrganizationMapping.class, "org").join(IssueToBranchMapping.class, "mapping.BRANCH_ID = branch.ID").join(RepositoryMapping.class, "branch.REPOSITORY_ID = repo.ID").join(OrganizationMapping.class, "repo.ORGANIZATION_ID = org.ID").where("org.DVCS_TYPE = ? AND repo.DELETED = ? AND repo.LINKED = ? AND " + baseWhereClause, params).order("NAME").limit(DAOConstants.MAXIMUM_ENTITIES_PER_ISSUE_KEY))));
    }

    public List<Branch> getBranchesForRepository(int repositoryId) {
        return BranchDaoImpl.asBranches((BranchMapping[])this.activeObjects.executeInTransaction(() -> (BranchMapping[])this.activeObjects.find(BranchMapping.class, Query.select().from(BranchMapping.class).alias(BranchMapping.class, "branch").alias(RepositoryMapping.class, "repo").join(RepositoryMapping.class, "branch.REPOSITORY_ID = repo.ID").where("repo.DELETED = ? AND repo.LINKED = ? AND branch.REPOSITORY_ID = ?", new Object[]{Boolean.FALSE, Boolean.TRUE, repositoryId}))));
    }

    private void associateBranchWithIssues(BranchMapping branchMapping, Iterable<String> issueKeys) {
        this.activeObjects.deleteWithSQL(IssueToBranchMapping.class, "BRANCH_ID = ? ", new Object[]{branchMapping});
        issueKeys.forEach(issueKey -> {
            MapRemovingNullCharacterFromStringValues map = new MapRemovingNullCharacterFromStringValues();
            map.put("ISSUE_KEY", issueKey);
            map.put("BRANCH_ID", branchMapping.getID());
            this.activeObjects.create(IssueToBranchMapping.class, (Map)map);
        });
    }
}

