/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.dao.ao;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.stereotype.Component;

@Component
public final class EntityBeanGenerator {
    public <T extends RawEntity> T createInstanceOf(Class<T> entityInterface) {
        if (!entityInterface.isInterface()) {
            throw new IllegalArgumentException("Expected an interface, got: " + entityInterface);
        }
        return (T)((RawEntity)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{entityInterface}, (InvocationHandler)new EntityBeanInterceptor(entityInterface)));
    }

    private static class EntityBeanInterceptor
    implements InvocationHandler {
        private static final ImmutableMap<Class<?>, Object> DEFAULTS = ImmutableMap.builder().put(Byte.TYPE, (Object)0).put(Short.TYPE, (Object)0).put(Integer.TYPE, (Object)0).put(Long.TYPE, (Object)0L).put(Float.TYPE, (Object)Float.valueOf(0.0f)).put(Double.TYPE, (Object)0.0).put(Character.TYPE, (Object)Character.valueOf('\u0000')).put(Boolean.TYPE, (Object)false).build();
        private final ImmutableMap<Method, InvocationHandler> beanMethodInterceptors;
        private final Map<String, Object> beanProperties = Maps.newHashMap();

        public EntityBeanInterceptor(Class<?> entityInterface) {
            this.beanMethodInterceptors = this.getBeanMethods(entityInterface);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if ("equals".equals(method.getName())) {
                    return this.equals(proxy, args[0]);
                }
                if ("hashCode".equals(method.getName())) {
                    return this.hashCode();
                }
                if ("toString".equals(method.getName())) {
                    return this.beanToString();
                }
                return method.invoke((Object)this, args);
            }
            InvocationHandler interceptor = (InvocationHandler)this.beanMethodInterceptors.get((Object)method);
            if (interceptor != null) {
                return interceptor.invoke(proxy, method, args);
            }
            throw new UnsupportedOperationException(method.getName() + " is not implemented (not a bean setter or getter)");
        }

        private ImmutableMap<Method, InvocationHandler> getBeanMethods(Class<?> entityInterface) {
            try {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Class<?> superInterface : entityInterface.getInterfaces()) {
                    builder.putAll(this.getBeanMethods(superInterface));
                }
                for (PropertyDescriptor descriptor : Introspector.getBeanInfo(entityInterface).getPropertyDescriptors()) {
                    Method writeMethod;
                    Method readMethod = descriptor.getReadMethod();
                    if (readMethod != null) {
                        builder.put((Object)readMethod, (Object)new Getter(descriptor.getName()));
                    }
                    if ((writeMethod = descriptor.getWriteMethod()) == null) continue;
                    builder.put((Object)writeMethod, (Object)new Setter(descriptor.getName()));
                }
                return builder.build();
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }

        private Object equals(Object thisObj, Object thatObj) {
            return thisObj == thatObj;
        }

        private String beanToString() {
            ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
            for (Map.Entry<String, Object> prop : this.beanProperties.entrySet()) {
                toStringBuilder.append(prop.getKey(), prop.getValue());
            }
            return toStringBuilder.build();
        }

        private class Setter
        extends PropertyInterceptor {
            public Setter(String propertyName) {
                super(propertyName);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                EntityBeanInterceptor.this.beanProperties.put(this.propertyName, args[0]);
                return null;
            }
        }

        private class Getter
        extends PropertyInterceptor {
            public Getter(String propertyName) {
                super(propertyName);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (EntityBeanInterceptor.this.beanProperties.containsKey(this.propertyName)) {
                    return EntityBeanInterceptor.this.beanProperties.get(this.propertyName);
                }
                Class<?> returnType = method.getReturnType();
                if (DEFAULTS.containsKey(returnType)) {
                    return DEFAULTS.get(returnType);
                }
                return null;
            }
        }

        private static abstract class PropertyInterceptor
        implements InvocationHandler {
            protected final String propertyName;

            public PropertyInterceptor(String propertyName) {
                this.propertyName = propertyName;
            }
        }
    }
}

