/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.crypto;

import com.atlassian.jira.plugins.dvcs.crypto.Encryptor;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultEncryptor
implements Encryptor {
    final Logger logger = LoggerFactory.getLogger(DefaultEncryptor.class);

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public String encrypt(String input, String organizationName, String hostUrl) {
        byte[] encrypted;
        try {
            byte[] key = (organizationName + hostUrl).getBytes("utf-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            encrypted = cipher.doFinal(input.getBytes("utf-8"));
        }
        catch (Exception e) {
            this.logger.debug("error encrypting", (Throwable)e);
            encrypted = new byte[]{};
        }
        BigInteger bi = new BigInteger(1, encrypted);
        return String.format("%0" + (encrypted.length << 1) + "X", bi);
    }

    public String decrypt(String password, String organizationName, String hostUrl) {
        if (password == null) {
            return null;
        }
        try {
            byte[] ciphertext = DefaultEncryptor.hexStringToByteArray(password);
            byte[] key = (organizationName + hostUrl).getBytes("utf-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] original = cipher.doFinal(ciphertext);
            String originalString = new String(original, "utf-8");
            return originalString;
        }
        catch (Exception e) {
            this.logger.debug("error decrypting", (Throwable)e);
            return "";
        }
    }
}

