/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.bitbucket.access;

import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BitbucketTeamService {
    @VisibleForTesting
    static final String BITBUCKET_DVCS_TYPE = "bitbucket";
    private final OrganizationService organizationService;

    @Autowired
    public BitbucketTeamService(OrganizationService organizationService) {
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
    }

    public List<Organization> getTeamsWithDefaultGroups() {
        return this.organizationService.getAll(false, BITBUCKET_DVCS_TYPE).stream().filter(org -> !org.getDefaultGroups().isEmpty()).collect(Collectors.toList());
    }
}

