/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.bitbucket.access;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.dvcs.bitbucket.access.BitbucketTeamService;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class BaseBitbucketAccessExtensionContextProvider
implements ContextProvider {
    @VisibleForTesting
    static final String CONTEXT_KEY_JIRA_BASE_URL = "jiraBaseUrl";
    @VisibleForTesting
    static final String CONTEXT_KEY_MORE_COUNT = "moreCount";
    @VisibleForTesting
    static final String CONTEXT_KEY_MORE_TEAMS = "moreTeams";
    @VisibleForTesting
    static final String CONTEXT_KEY_TEAMS_WITH_DEFAULT_GROUPS = "teamsWithDefaultGroups";
    private static final int TEAMS_DISPLAY_THRESHOLD = 3;
    protected final PageBuilderService pageBuilderService;
    private final ApplicationProperties applicationProperties;
    private final BitbucketTeamService bitbucketTeamService;

    protected BaseBitbucketAccessExtensionContextProvider(ApplicationProperties applicationProperties, BitbucketTeamService bitbucketTeamService, PageBuilderService pageBuilderService) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.bitbucketTeamService = (BitbucketTeamService)Preconditions.checkNotNull((Object)bitbucketTeamService);
        this.pageBuilderService = (PageBuilderService)Preconditions.checkNotNull((Object)pageBuilderService);
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        List<Organization> bitbucketTeamsWithDefaultGroups = this.bitbucketTeamService.getTeamsWithDefaultGroups();
        List bitbucketTeamNames = Lists.transform(bitbucketTeamsWithDefaultGroups, Organization::getName);
        this.requireResourcesAndData(bitbucketTeamsWithDefaultGroups);
        return ImmutableMap.of((Object)CONTEXT_KEY_JIRA_BASE_URL, (Object)this.applicationProperties.getString("jira.baseurl"), (Object)CONTEXT_KEY_MORE_COUNT, (Object)Math.max(0, bitbucketTeamsWithDefaultGroups.size() - 3), (Object)CONTEXT_KEY_MORE_TEAMS, this.inlineDialogContent(bitbucketTeamNames), (Object)CONTEXT_KEY_TEAMS_WITH_DEFAULT_GROUPS, (Object)bitbucketTeamNames);
    }

    protected abstract void requireResourcesAndData(List<Organization> var1);

    private List<String> inlineDialogContent(List<String> bitbucketTeamNames) {
        if (bitbucketTeamNames.size() > 3) {
            return bitbucketTeamNames.subList(3, bitbucketTeamNames.size());
        }
        return Collections.emptyList();
    }
}

