/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.bitbucket.access;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.dvcs.bitbucket.access.BaseBitbucketAccessExtensionContextProvider;
import com.atlassian.jira.plugins.dvcs.bitbucket.access.BitbucketTeamService;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class AddUserBitbucketAccessExtensionContextProvider
extends BaseBitbucketAccessExtensionContextProvider {
    @VisibleForTesting
    static final String REQUIRED_DATA_BITBUCKET_INVITE_TO_GROUPS_KEY = "bitbucket-invite-to-groups";
    @VisibleForTesting
    static final String REQUIRED_WEB_RESOURCE_COMPLETE_KEY = "com.atlassian.jira.plugins.jira-bitbucket-connector-plugin:entrypoint-add-user-bitbucket-access-extension";
    private static final String ORGANIZATION_GROUP_PAIR_SEPARATOR = ";";
    private static final String ORGANIZATION_GROUP_SEPARATOR = ":";

    public AddUserBitbucketAccessExtensionContextProvider(@ComponentImport ApplicationProperties applicationProperties, BitbucketTeamService bitbucketTeamService, @ComponentImport PageBuilderService pageBuilderService) {
        super(applicationProperties, bitbucketTeamService, pageBuilderService);
    }

    @Override
    protected void requireResourcesAndData(List<Organization> bitbucketTeamsWithDefaultGroups) {
        if (!bitbucketTeamsWithDefaultGroups.isEmpty()) {
            String inviteToGroups = this.inviteToGroups(bitbucketTeamsWithDefaultGroups);
            this.pageBuilderService.assembler().resources().requireWebResource(REQUIRED_WEB_RESOURCE_COMPLETE_KEY);
            this.pageBuilderService.assembler().data().requireData(REQUIRED_DATA_BITBUCKET_INVITE_TO_GROUPS_KEY, inviteToGroups);
        }
    }

    private String inviteToGroups(Collection<Organization> organizations) {
        Iterable organisationGroupPairs = organizations.stream().flatMap(org -> org.getDefaultGroups().stream().map(group -> org.getId() + ORGANIZATION_GROUP_SEPARATOR + group.getSlug())).collect(Collectors.toList());
        return Joiner.on((String)ORGANIZATION_GROUP_PAIR_SEPARATOR).join(organisationGroupPairs);
    }
}

