/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.BranchHeadMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.IssueToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryToChangesetMapping;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.collect.Lists;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_13_RemoveFutureChangesets
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(To_13_RemoveFutureChangesets.class);
    private static final Date DATE_IN_THE_PAST = new Date(0L);
    private static final Date TOMORROW_DATE = To_13_RemoveFutureChangesets.getTomorrow();

    private static Date getTomorrow() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        return cal.getTime();
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        log.info("upgrade [ " + this.getModelVersion() + " ]: started");
        try {
            activeObjects.migrate(new Class[]{OrganizationMapping.class, RepositoryMapping.class, ChangesetMapping.class, IssueToChangesetMapping.class, RepositoryToChangesetMapping.class, BranchHeadMapping.class});
            for (ChangesetMapping changesetMapping : this.getChangesetsFromFuture(activeObjects)) {
                this.setChangesetDate(activeObjects, DATE_IN_THE_PAST, changesetMapping);
            }
            log.info("upgrade [ " + this.getModelVersion() + " ]: finished");
        }
        catch (RuntimeException e) {
            log.warn("Cleaning of future dates did not finished correctly. This will not affect the behavior, only the changesets from the future will be still there. To fix them run full synchronization.", (Throwable)e);
        }
    }

    private void setChangesetDate(ActiveObjects activeObjects, Date dateInThePast, final ChangesetMapping changesetMapping) {
        activeObjects.executeInTransaction((TransactionCallback)new TransactionCallback<ChangesetMapping>(){

            public ChangesetMapping doInTransaction() {
                log.warn("Changeset [{}] has date set in the future [{}]. Setting date to [{}].", new Object[]{changesetMapping.getNode(), changesetMapping.getDate(), DATE_IN_THE_PAST});
                changesetMapping.setDate(DATE_IN_THE_PAST);
                changesetMapping.setSmartcommitAvailable(false);
                changesetMapping.save();
                return changesetMapping;
            }
        });
    }

    private Iterable<ChangesetMapping> getChangesetsFromFuture(final ActiveObjects activeObjects) {
        return new Iterable<ChangesetMapping>(){

            @Override
            public Iterator<ChangesetMapping> iterator() {
                return new ChangesetsFromFutureIterator(activeObjects);
            }
        };
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"13");
    }

    private final class ChangesetsFromFutureIterator
    implements Iterator<ChangesetMapping> {
        private final ActiveObjects activeObjects;
        private final List<ChangesetMapping> currentPage = Lists.newArrayList();

        public ChangesetsFromFutureIterator(ActiveObjects activeObjects) {
            this.activeObjects = activeObjects;
        }

        @Override
        public boolean hasNext() {
            this.readCurrentPage();
            return !this.currentPage.isEmpty();
        }

        @Override
        public ChangesetMapping next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentPage.remove(0);
        }

        private void readCurrentPage() {
            ChangesetMapping[] latestChangesets;
            if (!this.currentPage.isEmpty()) {
                return;
            }
            Query query = Query.select().order("DATE desc");
            query.limit(20);
            for (ChangesetMapping changesetMapping : latestChangesets = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, query)) {
                if (changesetMapping.getDate() == null || !changesetMapping.getDate().after(TOMORROW_DATE)) continue;
                this.currentPage.add(changesetMapping);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

