/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.IssueToChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryToChangesetMapping;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import net.java.ao.DatabaseProvider;
import net.java.ao.Entity;
import net.java.ao.EntityManager;
import net.java.ao.Query;
import net.java.ao.schema.TableNameConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_12_SplitUpChangesetsMigrator
implements ActiveObjectsUpgradeTask {
    private static final int COMMIT_BATCH_SIZE = 8192;
    private static final Logger logger = LoggerFactory.getLogger(To_12_SplitUpChangesetsMigrator.class);
    private static final ModelVersion MODEL_VERSION = ModelVersion.valueOf((String)"12");
    private ActiveObjects activeObjects;
    private Progress progress;
    private DatabaseProvider databaseProvider;
    private Connection connection;
    private TableNameConverter tableNameConverter;
    private String quote;

    public ModelVersion getModelVersion() {
        return MODEL_VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
        logger.info("upgrade [ " + this.getModelVersion() + " ]: started");
        try {
            activeObjects.migrate(new Class[]{OrganizationMapping.class, RepositoryMapping.class, ChangesetMapping.class, IssueToChangesetMapping.class, RepositoryToChangesetMapping.class});
            if (this.init()) {
                this.sanityClean();
                int totalCount = activeObjects.count(ChangesetMapping.class, Query.select().where("ISSUE_KEY is not null ", new Object[0]));
                int readBatchSize = Math.max(8192, totalCount / 4);
                this.progress = new Progress(totalCount);
                this.progress.update(0);
                ChangesetResult uniqueChangeset = null;
                while (true) {
                    Statement batchStatement = this.connection.createStatement();
                    batchStatement.setMaxRows(readBatchSize);
                    ResultSet founded = batchStatement.executeQuery(this.newBatchSQL());
                    ChangesetResultCursor changesetCursor = new ChangesetResultCursor(founded);
                    if (!changesetCursor.hasNext()) break;
                    uniqueChangeset = this.processBatch(changesetCursor, uniqueChangeset);
                    batchStatement.close();
                }
            }
            logger.info("upgrade [ " + this.getModelVersion() + " ]: finished");
        }
        catch (SQLException e) {
            if (e.getNextException() != null) {
                logger.error("Next exception of statement was: ", (Throwable)e.getNextException());
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void sanityClean() throws SQLException {
        Statement sanityStatement = this.connection.createStatement();
        sanityStatement.executeUpdate("delete from " + this.table(ChangesetMapping.class) + " where (" + this.column("REPOSITORY_ID") + " != 0  and " + this.column("REPOSITORY_ID") + " not in ( select " + this.column("ID") + " from " + this.table(RepositoryMapping.class) + " )) or " + this.column("REPOSITORY_ID") + " is null ");
        sanityStatement.close();
        this.connection.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangesetResult processBatch(ChangesetResultCursor changesetCursor, ChangesetResult uniqueChangeset) throws SQLException {
        do {
            int count = 0;
            PreparedStatement markAsUpdatedStatement = this.newMarkAsUpdatedStatement();
            PreparedStatement deleteChangesetStatement = this.newDeleteChangesetStatement();
            PreparedStatement issueToChangesetStatement = this.newIssueToChangesetStatement();
            PreparedStatement repositoryToChangesetStatement = this.newRepositoryToChangesetStatement();
            while (changesetCursor.hasNext() && count < 8192) {
                ChangesetResult current = changesetCursor.next();
                ++count;
                String currentNode = this.resolveChangesetNode(current.rawNode, current.node);
                boolean isDuplicate = false;
                if (uniqueChangeset == null) {
                    uniqueChangeset = this.findUniqueChangesetAfterRestart(this.activeObjects, currentNode);
                }
                if (uniqueChangeset != null) {
                    String uniqueChangesetNode = this.resolveChangesetNode(uniqueChangeset.rawNode, uniqueChangeset.node);
                    if (StringUtils.isBlank((CharSequence)uniqueChangesetNode)) {
                        logger.warn("The changeset with no hash found, it will be deleted.");
                        this.addDeleteChangesetStatement(deleteChangesetStatement, uniqueChangeset);
                        continue;
                    }
                    if (currentNode.equals(uniqueChangesetNode)) {
                        isDuplicate = true;
                    }
                }
                if (!isDuplicate) {
                    uniqueChangeset = current;
                }
                if (current.projectKey != null && !"NON_EXISTING".equals(current.projectKey)) {
                    this.addIssueToChangesetStatement(issueToChangesetStatement, uniqueChangeset, current);
                }
                this.addRepositoryToChangesetStatement(repositoryToChangesetStatement, uniqueChangeset, current);
                if (isDuplicate) {
                    this.addDeleteChangesetStatement(deleteChangesetStatement, current);
                    continue;
                }
                this.addMarkAsUpdatedStatement(markAsUpdatedStatement, uniqueChangeset);
            }
            boolean rollback = true;
            try {
                issueToChangesetStatement.executeBatch();
                issueToChangesetStatement.close();
                markAsUpdatedStatement.executeBatch();
                markAsUpdatedStatement.close();
                deleteChangesetStatement.executeBatch();
                deleteChangesetStatement.close();
                repositoryToChangesetStatement.executeBatch();
                repositoryToChangesetStatement.close();
                this.connection.commit();
                rollback = false;
            }
            finally {
                if (rollback) {
                    this.connection.rollback();
                }
            }
            this.progress.update(count);
        } while (changesetCursor.hasNext());
        return uniqueChangeset;
    }

    private String resolveChangesetNode(String rawNode, String node) {
        if (StringUtils.isBlank((CharSequence)rawNode)) {
            return node;
        }
        return rawNode;
    }

    private ChangesetResult findUniqueChangesetAfterRestart(ActiveObjects activeObjects, String currentNode) {
        ChangesetMapping[] founded = (ChangesetMapping[])activeObjects.find(ChangesetMapping.class, Query.select().where("ISSUE_KEY is null AND ( RAW_NODE = ? OR NODE = ? )", new Object[]{currentNode, currentNode}));
        if (founded.length == 1) {
            ChangesetMapping result = founded[0];
            return new ChangesetResult(result.getID(), result.getRawNode(), result.getNode(), result.getRepositoryId(), result.getProjectKey(), result.getIssueKey());
        }
        if (founded.length == 0) {
            return null;
        }
        throw new RuntimeException("It should never happened - there are multiple proceed changesets with the same raw node: " + currentNode);
    }

    private boolean init() throws SQLException {
        Query query = Query.select().where("ISSUE_KEY is not null ", new Object[0]);
        query.setLimit(1);
        ChangesetMapping[] founded = (ChangesetMapping[])this.activeObjects.find(ChangesetMapping.class, query);
        if (founded.length != 1) {
            return false;
        }
        EntityManager entityManager = founded[0].getEntityManager();
        this.tableNameConverter = entityManager.getTableNameConverter();
        this.databaseProvider = entityManager.getProvider();
        this.connection = this.databaseProvider.getConnection();
        this.connection.setAutoCommit(false);
        this.quote = this.connection.getMetaData().getIdentifierQuoteString();
        return true;
    }

    private String newBatchSQL() {
        return "select " + StringUtils.join((Object[])new String[]{this.column("ID"), this.column("RAW_NODE"), this.column("NODE"), this.column("REPOSITORY_ID"), this.column("PROJECT_KEY"), this.column("ISSUE_KEY")}, (String)", ") + " from " + this.table(ChangesetMapping.class) + " where " + this.column("PROJECT_KEY") + " is not null and " + this.column("ISSUE_KEY") + " is not null  order by " + this.column("RAW_NODE") + ", " + this.column("NODE") + ", " + this.column("ID") + " ASC";
    }

    private PreparedStatement newIssueToChangesetStatement() throws SQLException {
        String sql = "insert into " + this.table(IssueToChangesetMapping.class) + " (" + StringUtils.join((Object[])new String[]{this.column("CHANGESET_ID"), this.column("PROJECT_KEY"), this.column("ISSUE_KEY")}, (String)", ") + ") values (?, ?, ?)";
        return this.connection.prepareStatement(sql);
    }

    private void addIssueToChangesetStatement(PreparedStatement statement, ChangesetResult unique, ChangesetResult current) throws SQLException {
        statement.setInt(1, unique.id);
        statement.setString(2, current.projectKey);
        statement.setString(3, current.issueKey);
        statement.addBatch();
    }

    private PreparedStatement newRepositoryToChangesetStatement() throws SQLException {
        String sql = "insert into " + this.table(RepositoryToChangesetMapping.class) + " (" + StringUtils.join((Object[])new String[]{this.column("CHANGESET_ID"), this.column("REPOSITORY_ID")}, (String)", ") + ") values (?, ?)";
        return this.connection.prepareStatement(sql);
    }

    private void addRepositoryToChangesetStatement(PreparedStatement statement, ChangesetResult unique, ChangesetResult current) throws SQLException {
        statement.setInt(1, unique.id);
        statement.setInt(2, current.repositoryId);
        statement.addBatch();
    }

    private PreparedStatement newDeleteChangesetStatement() throws SQLException {
        String sql = "delete from " + this.table(ChangesetMapping.class) + " where " + this.column("ID") + " = ?";
        return this.connection.prepareStatement(sql);
    }

    private void addDeleteChangesetStatement(PreparedStatement statement, ChangesetResult current) throws SQLException {
        statement.setInt(1, current.id);
        statement.addBatch();
    }

    private PreparedStatement newMarkAsUpdatedStatement() throws SQLException {
        String sql = "update " + this.table(ChangesetMapping.class) + " set " + this.column("REPOSITORY_ID") + " = ?, " + this.column("PROJECT_KEY") + " = ?, " + this.column("ISSUE_KEY") + " = ?  where " + this.column("ID") + " = ? ";
        return this.connection.prepareStatement(sql);
    }

    private void addMarkAsUpdatedStatement(PreparedStatement statement, ChangesetResult changesetResult) throws SQLException {
        statement.setInt(1, 0);
        statement.setNull(2, 0);
        statement.setNull(3, 0);
        statement.setInt(4, changesetResult.id);
        statement.addBatch();
    }

    private String table(Class<? extends Entity> entity) {
        String tableName = this.tableNameConverter.getName(entity);
        return this.databaseProvider.withSchema(tableName);
    }

    private String column(String columnName) {
        if (StringUtils.isBlank((CharSequence)this.quote)) {
            return columnName;
        }
        return this.quote + columnName + this.quote;
    }

    private class Progress {
        private final int totalCount;
        int currentCount;

        public Progress(int totalCount) {
            this.totalCount = totalCount;
        }

        private void update(int proceedCount) {
            if (this.totalCount > 0) {
                this.currentCount += proceedCount;
                logger.info(this.currentCount + " from " + this.totalCount + " [" + this.currentCount * 100 / this.totalCount + "%] entities have been already processed");
            }
        }
    }

    private class ChangesetResultCursor
    implements Iterator<ChangesetResult> {
        private final ResultSet resultSet;
        private boolean hasNext;

        ChangesetResultCursor(ResultSet resultSet) {
            this.resultSet = resultSet;
            try {
                this.hasNext = resultSet.next();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public ChangesetResult next() {
            try {
                ChangesetResult result = new ChangesetResult(this.resultSet.getInt(1), this.resultSet.getString(2), this.resultSet.getString(3), this.resultSet.getInt(4), this.resultSet.getString(5), this.resultSet.getString(6));
                this.hasNext = this.resultSet.next();
                return result;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChangesetResult {
        private final int id;
        private final String rawNode;
        private final String node;
        private final int repositoryId;
        private final String projectKey;
        private final String issueKey;

        ChangesetResult(int id, String rawNode, String node, int repositoryId, String projectKey, String issueKey) {
            this.id = id;
            this.rawNode = rawNode;
            this.node = node;
            this.repositoryId = repositoryId;
            this.projectKey = projectKey;
            this.issueKey = issueKey;
        }
    }
}

