/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_11_UpgradeOAuthDetails {
    private static final Logger log = LoggerFactory.getLogger(To_11_UpgradeOAuthDetails.class);
    private final PluginSettings settings;

    public To_11_UpgradeOAuthDetails(PluginSettings settings) {
        this.settings = settings;
    }

    public void doMigrate() {
        String clientId = this.getProperty("bitbucketRepositoryClientID");
        String secret = this.getProperty("bitbucketRepositoryClientSecret");
        String url = "https://bitbucket.org";
        this.store("bitbucket", clientId, secret, "https://bitbucket.org");
        this.removeProperty("bitbucketRepositoryClientID");
        this.removeProperty("bitbucketRepositoryClientSecret");
        clientId = this.getProperty("githubRepositoryClientID");
        secret = this.getProperty("githubRepositoryClientSecret");
        url = "https://github.com";
        this.store("github", clientId, secret, url);
        this.removeProperty("githubRepositoryClientID");
        this.removeProperty("githubRepositoryClientSecret");
        clientId = this.getProperty("ghEnterpriseRepositoryClientID");
        secret = this.getProperty("ghEnterpriseRepositoryClientSecret");
        url = this.getProperty("ghEnterpriseRepositoryHostUrl");
        this.store("githube", clientId, secret, url);
        this.removeProperty("ghEnterpriseRepositoryClientID");
        this.removeProperty("ghEnterpriseRepositoryClientSecret");
        this.removeProperty("ghEnterpriseRepositoryHostUrl");
    }

    private void store(String hostId, String clientId, String secret, String url) {
        this.setProperty("dvcs.connector." + hostId + ".clientId", clientId);
        this.setProperty("dvcs.connector." + hostId + ".secret", secret);
        this.setProperty("dvcs.connector." + hostId + ".url", url);
    }

    private void setProperty(String name, String value) {
        this.settings.put(name, (Object)value);
        log.info("Storing property " + name + " = " + value);
    }

    private String getProperty(String name) {
        String value = (String)this.settings.get(name);
        log.info("Reading property " + name + " = " + value);
        return value;
    }

    private void removeProperty(String name) {
        this.settings.remove(name);
        log.info("Removing property " + name);
    }
}

