/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.To_11_UpgradeOAuthDetails;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_11_AddKeyAndSecretToBBAccounts
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(To_11_AddKeyAndSecretToBBAccounts.class);
    private final PluginSettings settings;

    public To_11_AddKeyAndSecretToBBAccounts(PluginSettingsFactory pluginSettingsFactory) {
        this.settings = pluginSettingsFactory.createGlobalSettings();
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        log.info("AO Upgrade task  [ " + this.getModelVersion() + " ] Adding OAuth key/secret to each bitbucket organization.");
        new To_11_UpgradeOAuthDetails(this.settings).doMigrate();
        this.addKeyAndSecretToBBAccounts(activeObjects);
    }

    private void addKeyAndSecretToBBAccounts(ActiveObjects activeObjects) {
        String key = (String)this.settings.get("dvcs.connector.bitbucket.clientId");
        String secret = (String)this.settings.get("dvcs.connector.bitbucket.secret");
        log.info("Bitbucket key / secret = " + key + " / " + secret);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)secret)) {
            log.warn("Bitbucket key/secret cannot be blank, nothing to upgrade");
            return;
        }
        activeObjects.executeInTransaction(() -> {
            OrganizationMapping[] organizationMappings;
            Query query = Query.select().where("DVCS_TYPE = ? ", new Object[]{"bitbucket"});
            for (OrganizationMapping organizationMapping : organizationMappings = (OrganizationMapping[])activeObjects.find(OrganizationMapping.class, query)) {
                String accessToken = organizationMapping.getAccessToken();
                String oauthKey = organizationMapping.getOauthKey();
                String oauthSecret = organizationMapping.getOauthSecret();
                if (StringUtils.isNotBlank((CharSequence)accessToken) && (StringUtils.isBlank((CharSequence)oauthKey) || StringUtils.isBlank((CharSequence)oauthSecret))) {
                    organizationMapping.setOauthKey(key);
                    organizationMapping.setOauthSecret(secret);
                    organizationMapping.save();
                    log.info("Setting key secret for {} {}", (Object)organizationMapping.getHostUrl(), (Object)organizationMapping.getName());
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)accessToken) || !StringUtils.isNotBlank((CharSequence)oauthKey) || !StringUtils.isNotBlank((CharSequence)oauthSecret)) continue;
                organizationMapping.setAccessToken(null);
                organizationMapping.save();
            }
            return null;
        });
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"11");
    }
}

