/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import java.util.Date;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_10_LastChangesetNodeMigrator
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(To_10_LastChangesetNodeMigrator.class);

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        log.debug("upgrade [ " + this.getModelVersion() + " ]");
        activeObjects.migrate(new Class[]{OrganizationMapping.class, RepositoryMapping.class, ChangesetMapping.class});
        this.populateLastChangesetNodeColumn(activeObjects);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"10");
    }

    private void populateLastChangesetNodeColumn(ActiveObjects activeObjects) {
        for (RepositoryMapping repository : (RepositoryMapping[])activeObjects.find(RepositoryMapping.class)) {
            Date repositoryLastCommitDate = repository.getLastCommitDate();
            if (repositoryLastCommitDate == null) continue;
            ChangesetMapping[] lastChangesetOrEmptyArray = (ChangesetMapping[])activeObjects.find(ChangesetMapping.class, Query.select().where("REPOSITORY_ID = ?", new Object[]{repository.getID()}).order("DATE DESC").limit(1));
            if (lastChangesetOrEmptyArray.length != 0) {
                repository.setLastChangesetNode(lastChangesetOrEmptyArray[0].getRawNode());
                repository.save();
                continue;
            }
            log.error("Repository '{}' within organization id '{}' has set LAST_COMMIT_DATE, but there are 0 changesets associated with this repository !", (Object)repository.getName(), (Object)repository.getOrganizationId());
        }
    }
}

