/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.IssueMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.ProjectMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.OrganizationMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.PasswordReEncryptor;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.RepositoryMapping;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.ao.EntityStreamCallback;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_08_ActiveObjectsV3Migrator
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(To_08_ActiveObjectsV3Migrator.class);
    private static final String ISSUE_KEY_REGEX = "([A-Z]{2,})-\\d+";
    private final PasswordReEncryptor passwordReEncryptor;

    public To_08_ActiveObjectsV3Migrator(PasswordReEncryptor passwordReEncryptor) {
        this.passwordReEncryptor = passwordReEncryptor;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        log.debug("upgrade [ " + this.getModelVersion() + " ]");
        activeObjects.migrate(new Class[]{ProjectMapping.class, IssueMapping.class, OrganizationMapping.class, RepositoryMapping.class, ChangesetMapping.class});
        activeObjects.deleteWithSQL(ChangesetMapping.class, "ID > ?", new Object[]{0});
        activeObjects.deleteWithSQL(OrganizationMapping.class, "ID > ?", new Object[]{0});
        activeObjects.deleteWithSQL(RepositoryMapping.class, "ID > ?", new Object[]{0});
        HashMap old2New = Maps.newHashMap();
        this.migrateOrganisationsAndRepositories(activeObjects, old2New);
        this.migrateChangesets(activeObjects, old2New);
    }

    private void migrateOrganisationsAndRepositories(ActiveObjects activeObjects, Map<Integer, Integer> old2New) {
        ProjectMapping[] ProjectMappings;
        for (ProjectMapping projectMapping : ProjectMappings = (ProjectMapping[])activeObjects.find(ProjectMapping.class)) {
            try {
                Map<String, Object> organisationData = this.createOrganisationMap(projectMapping);
                OrganizationMapping organisationMapping = this.insertOrganisation(organisationData, activeObjects);
                Map<String, Object> repositoryData = this.createRepositoryMap(organisationMapping.getID(), projectMapping);
                RepositoryMapping repositoryMapping = this.insertRepository(repositoryData, activeObjects);
                old2New.put(projectMapping.getID(), repositoryMapping.getID());
            }
            catch (Exception e) {
                log.error("Error during DVCS data migration: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private Map<String, Object> createOrganisationMap(ProjectMapping pm) throws MalformedURLException {
        URL url = new URL(pm.getRepositoryUrl());
        String protocol = url.getProtocol();
        String hostname = url.getHost();
        String path = url.getPath();
        String[] split = StringUtils.split((String)path, (String)"/");
        if (split.length < 2) {
            throw new SourceControlException("Expected url is https://domainname.com/username/repository");
        }
        String owner = split[0];
        HashMap organisationMap = Maps.newHashMap();
        String hostUrl = MessageFormat.format("{0}://{1}", protocol, hostname);
        organisationMap.put("HOST_URL", hostUrl);
        organisationMap.put("NAME", owner);
        organisationMap.put("DVCS_TYPE", pm.getRepositoryType());
        organisationMap.put("ADMIN_USERNAME", pm.getAdminUsername());
        organisationMap.put("ADMIN_PASSWORD", this.reEncryptPassword(pm.getAdminPassword(), pm.getProjectKey(), pm.getRepositoryUrl(), owner, hostUrl));
        organisationMap.put("ACCESS_TOKEN", pm.getAccessToken());
        organisationMap.put("AUTOLINK_NEW_REPOS", false);
        return organisationMap;
    }

    private OrganizationMapping insertOrganisation(Map<String, Object> organisationMap, ActiveObjects activeObjects) {
        String hostUrl = (String)organisationMap.get("HOST_URL");
        String name = (String)organisationMap.get("NAME");
        OrganizationMapping[] existing = (OrganizationMapping[])activeObjects.find(OrganizationMapping.class, "HOST_URL = ? and NAME = ?", new Object[]{hostUrl, name});
        if (existing.length > 0) {
            return existing[0];
        }
        log.debug("Adding new organisation: " + organisationMap);
        return (OrganizationMapping)activeObjects.create(OrganizationMapping.class, organisationMap);
    }

    private Map<String, Object> createRepositoryMap(int organisationId, ProjectMapping projectMapping) throws MalformedURLException {
        URL url = new URL(projectMapping.getRepositoryUrl());
        String path = url.getPath();
        String[] split = StringUtils.split((String)path, (String)"/");
        if (split.length < 2) {
            throw new SourceControlException("Expected url is https://domainname.com/username/repository");
        }
        String slug = split[1];
        String name = projectMapping.getRepositoryName() == null ? slug : projectMapping.getRepositoryName();
        HashMap repositoryMap = Maps.newHashMap();
        repositoryMap.put("ORGANIZATION_ID", organisationId);
        repositoryMap.put("SLUG", slug);
        repositoryMap.put("NAME", name);
        repositoryMap.put("LAST_COMMIT_DATE", projectMapping.getLastCommitDate());
        repositoryMap.put("LINKED", true);
        repositoryMap.put("DELETED", false);
        log.debug("Migrating repository : " + repositoryMap);
        return repositoryMap;
    }

    private RepositoryMapping insertRepository(Map<String, Object> repositoryMap, ActiveObjects activeObjects) {
        return (RepositoryMapping)activeObjects.create(RepositoryMapping.class, repositoryMap);
    }

    private void migrateChangesets(final ActiveObjects activeObjects, final Map<Integer, Integer> old2New) {
        activeObjects.stream(IssueMapping.class, (EntityStreamCallback)new EntityStreamCallback<IssueMapping, Integer>(){

            public void onRowRead(IssueMapping issueMapping) {
                String projectKey = To_08_ActiveObjectsV3Migrator.this.extractProjectKey(issueMapping.getIssueId());
                if (StringUtils.isBlank((CharSequence)projectKey)) {
                    log.warn("Unable to extract project key from issue key: " + issueMapping.getID() + ", " + issueMapping.getNode() + ", " + issueMapping.getIssueId() + ", " + issueMapping.getMessage());
                }
                HashMap changesetMap = Maps.newHashMap();
                changesetMap.put("REPOSITORY_ID", old2New.get(issueMapping.getRepositoryId()));
                changesetMap.put("ISSUE_KEY", issueMapping.getIssueId());
                changesetMap.put("PROJECT_KEY", projectKey);
                changesetMap.put("NODE", issueMapping.getNode());
                changesetMap.put("RAW_AUTHOR", issueMapping.getRawAuthor());
                changesetMap.put("AUTHOR", issueMapping.getAuthor());
                changesetMap.put("DATE", issueMapping.getDate());
                changesetMap.put("RAW_NODE", issueMapping.getRawNode());
                changesetMap.put("BRANCH", issueMapping.getBranch());
                changesetMap.put("MESSAGE", issueMapping.getMessage());
                changesetMap.put("PARENTS_DATA", issueMapping.getParentsData());
                changesetMap.put("FILES_DATA", issueMapping.getFilesData());
                changesetMap.put("VERSION", issueMapping.getVersion());
                activeObjects.create(ChangesetMapping.class, (Map)changesetMap);
            }
        });
    }

    String extractProjectKey(String issueKey) {
        if (StringUtils.isBlank((CharSequence)issueKey)) {
            return null;
        }
        Pattern projectKeyPattern = Pattern.compile(ISSUE_KEY_REGEX, 2);
        Matcher match = projectKeyPattern.matcher(issueKey);
        if (match.find()) {
            String projectKey = match.group(1);
            return projectKey;
        }
        return null;
    }

    private String reEncryptPassword(String password, String projectKey, String repositoryUrl, String organisationName, String hostUrl) {
        if (password == null) {
            return null;
        }
        return this.passwordReEncryptor.reEncryptPassword(password, projectKey, repositoryUrl, organisationName, hostUrl);
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"8");
    }
}

