/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v3;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class PasswordReEncryptor {
    private static final Logger log = LoggerFactory.getLogger(PasswordReEncryptor.class);
    private final ProjectManager projectManager;

    @Autowired
    public PasswordReEncryptor(@ComponentImport ProjectManager projectManager) {
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    String reEncryptPassword(String password, String projectKey, String repositoryUrl, String organizationName, String hostUrl) {
        String unencrypted = this.decrypt(password, projectKey, repositoryUrl);
        String newHash = this.encrypt(unencrypted, organizationName, hostUrl);
        log.debug("repoUrl: " + repositoryUrl + " [" + password + "->" + newHash + "]");
        return newHash;
    }

    private String decrypt(String password, String projectKey, String repoURL) {
        if (password == null) {
            return null;
        }
        try {
            byte[] ciphertext = PasswordReEncryptor.hexStringToByteArray(password);
            String projectID = this.projectManager.getProjectObjByKey(projectKey).getId().toString();
            byte[] key = (projectID + repoURL).getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeySpec);
            byte[] original = cipher.doFinal(ciphertext);
            String originalString = new String(original);
            return originalString;
        }
        catch (Exception e) {
            log.debug("error encrypting", (Throwable)e);
            return "";
        }
    }

    private String encrypt(String input, String organizationName, String hostUrl) {
        byte[] encrypted;
        try {
            byte[] key = (organizationName + hostUrl).getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeySpec);
            encrypted = cipher.doFinal(input.getBytes());
        }
        catch (Exception e) {
            log.debug("error encrypting", (Throwable)e);
            encrypted = new byte[]{};
        }
        BigInteger bi = new BigInteger(1, encrypted);
        return String.format("%0" + (encrypted.length << 1) + "X", bi);
    }
}

