/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.IssueMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.ProjectMapping;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_06_GithubRepositories
implements ActiveObjectsUpgradeTask {
    private final Logger log = LoggerFactory.getLogger(To_06_GithubRepositories.class);
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ProjectManager projectManager;

    public To_06_GithubRepositories(ProjectManager projectManager, PluginSettingsFactory pluginSettingsFactory) {
        this.projectManager = projectManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    private List<String> getRepositories(String projectKey) {
        List<String> repoUrls = (List<String>)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("githubRepositoryURLArray");
        return repoUrls != null ? repoUrls : Collections.emptyList();
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects activeObjects) {
        this.log.debug("upgrade [ " + this.getModelVersion() + " ]");
        activeObjects.migrate(new Class[]{ProjectMapping.class, IssueMapping.class});
        List projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            String projectKey = project.getKey();
            this.log.debug(" === migrating repositories for project [{}] === ", (Object)projectKey);
            List<String> repositoriesUrls = this.getRepositories(projectKey);
            for (String repositoryUrl : repositoriesUrls) {
                this.log.debug("migrating repository [{}]", (Object)repositoryUrl);
                ProjectMapping pm = this.migrateRepository(activeObjects, projectKey, repositoryUrl);
                this.migrateIssueMappings(activeObjects, projectKey, repositoryUrl, pm);
            }
        }
    }

    private void migrateIssueMappings(ActiveObjects activeObjects, String projectKey, String repositoryUrl, ProjectMapping pm) {
        ArrayList issueIds = (ArrayList)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("githubIssueIDs" + repositoryUrl);
        if (issueIds != null) {
            for (String issueId : issueIds) {
                ArrayList commitArray = (ArrayList)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("githubIssueCommitArray" + issueId);
                if (commitArray == null) continue;
                for (String commit : commitArray) {
                    String node = this.extractNode(commit);
                    this.log.debug("migrating commit mapping node:[{}], issueId:[{}]", (Object)node, (Object)issueId);
                    HashMap map = Maps.newHashMap();
                    map.put("REPOSITORY_ID", pm.getID());
                    map.put("NODE", node);
                    map.put("ISSUE_ID", issueId);
                    activeObjects.create(IssueMapping.class, (Map)map);
                }
            }
        }
    }

    private ProjectMapping migrateRepository(ActiveObjects activeObjects, String projectKey, String repositoryUrl) {
        String fixedUrl = this.fixUrl(repositoryUrl);
        String access_token = (String)this.pluginSettingsFactory.createSettingsForKey(projectKey).get("githubRepositoryAccessToken" + repositoryUrl);
        HashMap map = Maps.newHashMap();
        map.put("REPOSITORY_URL", fixedUrl);
        map.put("PROJECT_KEY", projectKey);
        map.put("REPOSITORY_TYPE", "github");
        map.put("ACCESS_TOKEN", access_token);
        return (ProjectMapping)activeObjects.create(ProjectMapping.class, (Map)map);
    }

    private String extractNode(String commitUrl) {
        return commitUrl.replaceAll("(.*/|\\?.*)", "");
    }

    private String fixUrl(String repository) {
        return repository.replaceAll("(https://.*?/.*?/.*?)/.*", "$1");
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"6");
    }
}

