/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.RepositoryUri;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.IssueMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v2.ProjectMapping;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class To_04_ActiveObjectsV2Migrator
implements ActiveObjectsUpgradeTask {
    private final Logger logger = LoggerFactory.getLogger(To_04_ActiveObjectsV2Migrator.class);

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping[] projectMappings;
        this.logger.debug("upgrade [ " + modelVersion + " ]");
        activeObjects.migrate(new Class[]{com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping.class, com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping.class, IssueMapping.class, ProjectMapping.class});
        ArrayList repositoriesToBeSynchronised = Lists.newArrayList();
        for (com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping projectMapping : projectMappings = (com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping[])activeObjects.find(com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping.class)) {
            com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping[] issueMappings;
            String username = projectMapping.getUsername();
            String password = projectMapping.getPassword();
            String originalUrl = projectMapping.getRepositoryUri();
            String projectKey = projectMapping.getProjectKey();
            int repositoryId = projectMapping.getID();
            String fixedUrl = RepositoryUri.parse(originalUrl).getRepositoryUrl();
            HashMap map = Maps.newHashMap();
            map.put("REPOSITORY_URL", fixedUrl);
            map.put("PROJECT_KEY", projectKey);
            if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
                map.put("ADMIN_USERNAME", username);
                map.put("ADMIN_PASSWORD", password);
            }
            ProjectMapping pm = (ProjectMapping)activeObjects.create(ProjectMapping.class, (Map)map);
            if (!fixedUrl.equals(originalUrl)) {
                repositoriesToBeSynchronised.add(pm.getID());
            }
            for (com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping issueMapping : issueMappings = (com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping[])activeObjects.find(com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping.class, "PROJECT_KEY = ? and REPOSITORY_URI = ?", new Object[]{projectKey, originalUrl})) {
                String node = issueMapping.getNode();
                String issueId = issueMapping.getIssueId();
                HashMap map2 = Maps.newHashMap();
                map2.put("REPOSITORY_ID", repositoryId);
                map2.put("NODE", node);
                map2.put("ISSUE_ID", issueId);
                activeObjects.create(IssueMapping.class, (Map)map2);
            }
        }
        this.logger.debug("completed uri to url migration");
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"4");
    }
}

