/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.RepositoryUri;
import com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uri2UrlMigrator
implements ActiveObjectsUpgradeTask {
    private final Logger logger = LoggerFactory.getLogger(Uri2UrlMigrator.class);

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        IssueMapping[] issueMappings;
        ProjectMapping[] projectMappings;
        activeObjects.migrate(new Class[]{IssueMapping.class, ProjectMapping.class});
        this.logger.debug("upgrade [ " + modelVersion + " ]");
        for (ProjectMapping projectMapping : projectMappings = (ProjectMapping[])activeObjects.find(ProjectMapping.class)) {
            RepositoryUri uri = RepositoryUri.parse(projectMapping.getRepositoryUri());
            projectMapping.setRepositoryUri(uri.getRepositoryUrl());
            projectMapping.save();
        }
        for (IssueMapping issueMapping : issueMappings = (IssueMapping[])activeObjects.find(IssueMapping.class)) {
            RepositoryUri uri = RepositoryUri.parse(issueMapping.getRepositoryUri());
            issueMapping.setRepositoryUri(uri.getRepositoryUrl());
            issueMapping.save();
        }
        this.logger.debug("completed uri to url migration");
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }
}

