/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import java.net.MalformedURLException;
import java.net.URL;

public class RepositoryUri {
    private final String owner;
    private final String slug;
    private final String branch;

    public RepositoryUri(String owner, String slug, String branch) {
        this.owner = owner;
        this.slug = slug;
        this.branch = branch;
    }

    public RepositoryUri(String owner, String slug) {
        this.owner = owner;
        this.slug = slug;
        this.branch = null;
    }

    public static RepositoryUri parse(String uri) {
        try {
            URL url = new URL(uri);
            uri = url.getPath();
            uri = uri.substring(1);
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        String[] split = uri.split("/");
        return new RepositoryUri(split[0], split[1], split.length > 2 ? split[2] : "default");
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getRepositoryUri() {
        return this.owner + "/" + this.slug + (this.branch != null ? "/" + this.branch : "");
    }

    public String getRepositoryUrl() {
        return "https://bitbucket.org/" + this.getRepositoryUri();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryUri that = (RepositoryUri)o;
        return !((this.branch == null ? that.branch != null : !this.branch.equals(that.branch)) || (this.owner == null ? that.owner != null : !this.owner.equals(that.owner)) || (this.slug == null ? that.slug != null : !this.slug.equals(that.slug)));
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (this.slug != null ? this.slug.hashCode() : 0);
        result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getRepositoryUri();
    }
}

