/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.jira.plugins.dvcs.ao.QueryHelper;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryHelperImpl
implements QueryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryHelperImpl.class);
    private final CachedReference<DataSourceMetaData> dataSourceMetaData;
    @Resource
    @ComponentImport
    private PluginAccessor pluginAccessor;
    @Resource
    @ComponentImport
    private DataSourceProvider dataSourceProvider;

    @Autowired
    public QueryHelperImpl(@ComponentImport CacheManager cacheManager) {
        this.dataSourceMetaData = cacheManager.getCachedReference(this.getClass().getName() + ".dataSourceMetaData", (Supplier)new Supplier<DataSourceMetaData>(){

            public DataSourceMetaData get() {
                Connection connection = null;
                try {
                    connection = QueryHelperImpl.this.dataSourceProvider.getDataSource().getConnection();
                    DatabaseType databaseType = QueryHelperImpl.this.dataSourceProvider.getDatabaseType();
                    String schema = QueryHelperImpl.this.dataSourceProvider.getSchema();
                    String quote = connection.getMetaData().getIdentifierQuoteString();
                    DataSourceMetaData dataSourceMetaData = new DataSourceMetaData(databaseType, schema, quote);
                    return dataSourceMetaData;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException e) {
                            LOGGER.error("Unable to close connection!", (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public String getAlias(String plainAlias) {
        if (DatabaseType.ORACLE.equals((Object)((DataSourceMetaData)this.dataSourceMetaData.get()).databaseType)) {
            return plainAlias.toUpperCase();
        }
        return plainAlias;
    }

    public String getSqlTableName(String plainTableName) {
        DataSourceMetaData dataSourceMetaData = (DataSourceMetaData)this.dataSourceMetaData.get();
        String result = "";
        if (StringUtils.isNotBlank((CharSequence)dataSourceMetaData.schema)) {
            result = result + dataSourceMetaData.schema + ".";
        }
        result = StringUtils.isNotBlank((CharSequence)dataSourceMetaData.quote) ? result + dataSourceMetaData.quote + plainTableName + dataSourceMetaData.quote : result + plainTableName;
        return result;
    }

    public String getSqlColumnName(String plainColumnName) {
        DataSourceMetaData dataSourceMetaData = (DataSourceMetaData)this.dataSourceMetaData.get();
        if (StringUtils.isNotBlank((CharSequence)dataSourceMetaData.quote)) {
            return dataSourceMetaData.quote + plainColumnName + dataSourceMetaData.quote;
        }
        return plainColumnName;
    }

    public String getOrder(QueryHelper.OrderClause ... orderClause) {
        Object orderClauseToString = this.isBugAOSupportOnlySingleColumnInsideOrderClause() ? new Function<QueryHelper.OrderClause, String>(){
            private boolean isFirst = true;

            public String apply(QueryHelper.OrderClause input) {
                if (this.isFirst) {
                    this.isFirst = false;
                    return input.getColumn() + ' ' + input.getOrder().name();
                }
                return QueryHelperImpl.this.getSqlColumnName(input.getColumn()) + ' ' + input.getOrder().name();
            }
        } : input -> input.getColumn() + ' ' + input.getOrder().name();
        return Joiner.on((String)", ").join(Iterables.transform(Arrays.asList(orderClause), (Function)orderClauseToString));
    }

    private boolean isBugAOSupportOnlySingleColumnInsideOrderClause() {
        return this.isBeforeAOVersion("0.20");
    }

    private boolean isBeforeAOVersion(String version) {
        String aoVersion = this.pluginAccessor.getPlugin("com.atlassian.activeobjects.activeobjects-plugin").getPluginInformation().getVersion();
        String[] aoVersionComponents = aoVersion.split("\\.");
        String[] versionComponents = version.split("\\.");
        for (int i = 0; i < versionComponents.length && aoVersionComponents.length >= i; ++i) {
            try {
                int aoVersionComponent = Integer.parseInt(aoVersionComponents[i]);
                int versionComponent = Integer.parseInt(versionComponents[i]);
                if (aoVersionComponent <= versionComponent) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static class DataSourceMetaData {
        private final DatabaseType databaseType;
        private final String schema;
        private final String quote;

        private DataSourceMetaData(DatabaseType databaseType, String schema, String quote) {
            this.databaseType = databaseType;
            this.schema = schema;
            this.quote = quote;
        }
    }
}

