/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.dvcs.activeobjects.BitbucketProjectSettings;
import com.atlassian.jira.plugins.dvcs.activeobjects.RepositoryUri;
import com.atlassian.jira.plugins.dvcs.activeobjects.v1.IssueMapping;
import com.atlassian.jira.plugins.dvcs.activeobjects.v1.ProjectMapping;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMigrator
implements ActiveObjectsUpgradeTask {
    private final Logger logger = LoggerFactory.getLogger(PropertyMigrator.class);
    private final ProjectManager projectManager;
    private final BitbucketProjectSettings settings;

    public PropertyMigrator(ProjectManager projectManager, BitbucketProjectSettings settings) {
        this.projectManager = projectManager;
        this.settings = settings;
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        this.logger.debug("upgrade [ " + modelVersion + " ]");
        activeObjects.migrate(new Class[]{IssueMapping.class, ProjectMapping.class});
        List projects = this.projectManager.getProjectObjects();
        for (Project project : projects) {
            String projectKey = project.getKey();
            List<String> repositories = this.settings.getRepositories(projectKey);
            for (String repository : repositories) {
                String username = this.settings.getUsername(projectKey, repository);
                String password = this.settings.getPassword(projectKey, repository);
                String repositoryUri = RepositoryUri.parse(repository).getRepositoryUri();
                this.logger.debug("migrate repository [ {} ]", (Object)repositoryUri);
                HashMap map = Maps.newHashMap();
                map.put("PROJECT_KEY", projectKey);
                map.put("REPOSITORY_URI", repositoryUri);
                map.put("USERNAME", username);
                map.put("PASSWORD", password);
                activeObjects.create(ProjectMapping.class, (Map)map);
                try {
                    List<String> issueIds = this.settings.getIssueIds(projectKey, repository);
                    for (String issueId : issueIds) {
                        List<String> commits = this.settings.getCommits(projectKey, repository, issueId);
                        for (String commit : commits) {
                            URL changesetURL = new URL(commit);
                            String changesetPath = changesetURL.getPath();
                            String node = changesetPath.substring(changesetPath.lastIndexOf("/") + 1);
                            this.logger.debug("add changeset [ {} ] to [ {} ]", (Object)changesetPath, (Object)issueId);
                            HashMap issueMap = Maps.newHashMap();
                            issueMap.put("NODE", node);
                            issueMap.put("PROJECT_KEY", projectKey);
                            issueMap.put("ISSUE_ID", issueId);
                            issueMap.put("REPOSITORY_URI", repositoryUri);
                            activeObjects.create(IssueMapping.class, (Map)issueMap);
                        }
                    }
                }
                catch (MalformedURLException e) {
                    this.logger.error("invalid repository url [ " + repository + " ] was not processed");
                }
            }
        }
        this.logger.debug("completed property migration");
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }
}

