/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.activeobjects;

import com.atlassian.jira.plugins.dvcs.activeobjects.BitbucketProjectSettings;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultBitbucketProjectSettings
implements BitbucketProjectSettings {
    public static final String PROGRESS_TIP = "tip";
    public static final String PROGRESS_COMPLETED = "completed";
    private final Logger logger = LoggerFactory.getLogger(DefaultBitbucketProjectSettings.class);
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public DefaultBitbucketProjectSettings(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory);
    }

    private String getStringProperty(String projectKey, String key) {
        return (String)this.pluginSettingsFactory.createSettingsForKey(projectKey).get(key);
    }

    private void setStringProperty(String projectKey, String key, String value) {
        this.pluginSettingsFactory.createSettingsForKey(projectKey).put(key, (Object)value);
    }

    private void removeValue(String projectKey, String key) {
        this.pluginSettingsFactory.createSettingsForKey(projectKey).remove(key);
    }

    private List<String> getStringListValue(String projectKey, String key) {
        List list = (List)this.pluginSettingsFactory.createSettingsForKey(projectKey).get(key);
        return list == null ? new ArrayList() : list;
    }

    private void setStringListValue(String projectKey, String key, List<String> value) {
        if (value != null && !value.isEmpty()) {
            this.pluginSettingsFactory.createSettingsForKey(projectKey).put(key, value);
        } else {
            this.removeValue(projectKey, key);
        }
    }

    @Override
    public void startSyncProgress(String projectKey, String repositoryUrl) {
        this.logger.debug("starting sync for [ {} ] at [ {} ]", (Object)projectKey, (Object)repositoryUrl);
        String key = "currentsync" + repositoryUrl + projectKey;
        String value = PROGRESS_TIP;
        this.setStringProperty(projectKey, key, value);
    }

    @Override
    public void setSyncProgress(String projectKey, String repositoryUrl, int revision) {
        this.logger.debug("setting progress for [ {} ] at [ {} ] to [ {} ]", new Object[]{projectKey, repositoryUrl, revision});
        this.setStringProperty(projectKey, "currentsync" + repositoryUrl + projectKey, String.valueOf(revision));
    }

    @Override
    public void completeSyncProgress(String projectKey, String repositoryUrl) {
        this.logger.debug("complete progress for [ {} ] at [ {} ]", (Object)projectKey, (Object)repositoryUrl);
        this.setStringProperty(projectKey, "currentsync" + repositoryUrl + projectKey, PROGRESS_COMPLETED);
        this.setStringProperty(projectKey, "bitbucketLastSyncTime" + repositoryUrl, new Date().toString());
    }

    @Override
    public int getCount(String projectKey, String repositoryUrl, String type) {
        String commitCountString = this.getStringProperty(projectKey, type + repositoryUrl);
        return commitCountString == null ? 0 : Integer.parseInt(commitCountString);
    }

    @Override
    public void resetCount(String projectKey, String repositoryUrl, String type, int count) {
        this.removeValue(projectKey, type + repositoryUrl);
    }

    @Override
    public void incrementCommitCount(String projectKey, String repositoryUrl, String type) {
        int commitCount = this.getCount(projectKey, repositoryUrl, type);
        this.setStringProperty(projectKey, type + repositoryUrl, String.valueOf(commitCount + 1));
    }

    @Override
    public String getUsername(String projectKey, String repositoryURL) {
        return this.getStringProperty(projectKey, "bitbucketUserName" + repositoryURL);
    }

    @Override
    public void setUsername(String projectKey, String repositoryURL, String username) {
        this.setStringProperty(projectKey, "bitbucketUserName" + repositoryURL, username);
    }

    @Override
    public String getPassword(String projectKey, String repositoryURL) {
        return this.getStringProperty(projectKey, "bitbucketPassword" + repositoryURL);
    }

    @Override
    public void setPassword(String projectKey, String repositoryURL, String password) {
        this.setStringProperty(projectKey, "bitbucketPassword" + repositoryURL, password);
    }

    @Override
    public List<String> getCommits(String projectKey, String repositoryURL, String issueId) {
        return this.getStringListValue(projectKey, "bitbucketIssueCommitArray" + issueId);
    }

    @Override
    public void setCommits(String projectKey, String repositoryURL, String issueId, List<String> commits) {
        String key = "bitbucketIssueCommitArray" + issueId;
        this.setStringListValue(projectKey, key, commits);
    }

    @Override
    public List<String> getIssueIds(String projectKey, String repositoryURL) {
        return this.getStringListValue(projectKey, "bitbucketIssueIDs" + repositoryURL);
    }

    @Override
    public void setIssueIds(String projectKey, String repositoryURL, List<String> issueIds) {
        this.setStringListValue(projectKey, "bitbucketIssueIDs" + repositoryURL, issueIds);
    }

    @Override
    public List<String> getRepositories(String projectKey) {
        return this.getStringListValue(projectKey, "bitbucketRepositoryURLArray");
    }

    @Override
    public void setRepositories(String projectKey, List<String> repositories) {
        this.setStringListValue(projectKey, "bitbucketRepositoryURLArray", repositories);
    }
}

